/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.masterreplica;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class CompletableEventLatchSupport<T, V> {
    private static final AtomicIntegerFieldUpdater<CompletableEventLatchSupport> NOTIFICATIONS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CompletableEventLatchSupport.class, "notifications");
    private static final AtomicIntegerFieldUpdater<CompletableEventLatchSupport> GATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CompletableEventLatchSupport.class, "gate");
    private static final int GATE_OPEN = 0;
    private static final int GATE_CLOSED = 1;
    private final int expectedCount;
    private final CompletableFuture<V> selfFuture = new CompletableFuture();
    private volatile ScheduledFuture<?> timeoutScheduleFuture;
    private volatile int notifications = 0;
    private volatile int gate = 0;

    public CompletableEventLatchSupport(int expectedCount) {
        this.expectedCount = expectedCount;
    }

    public final int getExpectedCount() {
        return this.expectedCount;
    }

    public final void accept(T value) {
        if (GATE_UPDATER.get(this) == 1) {
            this.onDrop(value);
            return;
        }
        this.onAccept(value);
        this.onNotification();
    }

    public final void accept(Throwable throwable) {
        if (GATE_UPDATER.get(this) == 1) {
            this.onDrop(throwable);
            return;
        }
        this.onError(throwable);
        this.onNotification();
    }

    private void onNotification() {
        if (NOTIFICATIONS_UPDATER.incrementAndGet(this) == this.expectedCount) {
            ScheduledFuture<?> timeoutScheduleFuture = this.timeoutScheduleFuture;
            this.timeoutScheduleFuture = null;
            if (timeoutScheduleFuture != null) {
                timeoutScheduleFuture.cancel(false);
            }
            this.emit();
        }
    }

    private void emit() {
        if (GATE_UPDATER.compareAndSet(this, 0, 1)) {
            this.onEmit(new Emission<V>(){

                @Override
                public void success(V value) {
                    CompletableEventLatchSupport.this.selfFuture.complete(value);
                }

                @Override
                public void error(Throwable exception) {
                    CompletableEventLatchSupport.this.selfFuture.completeExceptionally(exception);
                }
            });
        }
    }

    protected void onAccept(T value) {
    }

    protected void onError(Throwable value) {
    }

    protected void onDrop(T value) {
    }

    protected void onDrop(Throwable value) {
    }

    protected void onEmit(Emission<V> emission) {
    }

    public final CompletionStage<V> getOrTimeout(Duration timeout, ScheduledExecutorService timeoutExecutor) {
        if (GATE_UPDATER.get(this) == 0 && this.timeoutScheduleFuture == null) {
            this.timeoutScheduleFuture = timeoutExecutor.schedule(this::emit, timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        return this.selfFuture;
    }

    public static interface Emission<T> {
        public void success(T var1);

        public void error(Throwable var1);
    }
}

