/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.internal;

import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class LettuceSets {
    private LettuceSets() {
    }

    public static <T> Set<T> newHashSet(Collection<? extends T> elements) {
        LettuceAssert.notNull(elements, "Collection must not be null");
        HashSet<T> set2 = new HashSet<T>(elements.size());
        set2.addAll(elements);
        return set2;
    }

    public static <T> Set<T> newHashSet(Iterable<? extends T> elements) {
        LettuceAssert.notNull(elements, "Iterable must not be null");
        if (elements instanceof Collection) {
            return LettuceSets.newHashSet((Collection)elements);
        }
        HashSet<T> set2 = new HashSet<T>();
        for (T e : elements) {
            set2.add(e);
        }
        return set2;
    }

    @SafeVarargs
    public static <T> Set<T> newHashSet(T ... elements) {
        LettuceAssert.notNull(elements, "Elements must not be null");
        HashSet set2 = new HashSet(elements.length);
        Collections.addAll(set2, elements);
        return set2;
    }

    @SafeVarargs
    public static <T> Set<T> unmodifiableSet(T ... elements) {
        return Collections.unmodifiableSet(LettuceSets.newHashSet(elements));
    }
}

