/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.internal;

import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public class DefaultMethods {
    private static final MethodHandleLookup methodHandleLookup = MethodHandleLookup.getMethodHandleLookup();

    public static MethodHandle lookupMethodHandle(Method method) throws ReflectiveOperationException {
        LettuceAssert.notNull((Object)method, "Method must not be null");
        LettuceAssert.isTrue(method.isDefault(), "Method is not a default method");
        return methodHandleLookup.lookup(method);
    }

    static enum MethodHandleLookup {
        OPEN{
            private final Optional<Constructor<MethodHandles.Lookup>> constructor = MethodHandleLookup.access$100();

            @Override
            MethodHandle lookup(Method method) throws ReflectiveOperationException {
                Constructor<MethodHandles.Lookup> constructor = this.constructor.orElseThrow(() -> new IllegalStateException("Could not obtain MethodHandles.lookup constructor"));
                return constructor.newInstance(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass());
            }

            @Override
            boolean isAvailable() {
                return this.constructor.isPresent();
            }
        }
        ,
        ENCAPSULATED{
            Method privateLookupIn = this.findBridgeMethod();

            @Override
            MethodHandle lookup(Method method) throws ReflectiveOperationException {
                MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
                return this.getLookup(method.getDeclaringClass()).findSpecial(method.getDeclaringClass(), method.getName(), methodType, method.getDeclaringClass());
            }

            private Method findBridgeMethod() {
                try {
                    return MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                }
                catch (ReflectiveOperationException e) {
                    return null;
                }
            }

            private MethodHandles.Lookup getLookup(Class<?> declaringClass) {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                if (this.privateLookupIn != null) {
                    try {
                        return (MethodHandles.Lookup)this.privateLookupIn.invoke(null, declaringClass, lookup);
                    }
                    catch (ReflectiveOperationException e) {
                        return lookup;
                    }
                }
                return lookup;
            }

            @Override
            boolean isAvailable() {
                return true;
            }
        };


        abstract MethodHandle lookup(Method var1) throws ReflectiveOperationException;

        abstract boolean isAvailable();

        public static MethodHandleLookup getMethodHandleLookup() {
            return Arrays.stream(MethodHandleLookup.values()).filter(MethodHandleLookup::isAvailable).findFirst().orElseThrow(() -> new IllegalStateException("No MethodHandleLookup available!"));
        }

        private static Optional<Constructor<MethodHandles.Lookup>> getLookupConstructor() {
            try {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return Optional.of(constructor);
            }
            catch (Exception ex) {
                if (ex.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    return Optional.empty();
                }
                throw new IllegalStateException(ex);
            }
        }

        static /* synthetic */ Optional access$100() {
            return MethodHandleLookup.getLookupConstructor();
        }
    }
}

