/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.event.jfr;

import com.grinderwolf.swm.internal.lettuce.core.event.jfr.EventRecorder;
import com.grinderwolf.swm.internal.lettuce.core.event.jfr.JfrEventRecorder;
import com.grinderwolf.swm.internal.lettuce.core.event.jfr.NoOpEventRecorder;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceClassUtils;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

class EventRecorderHolder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EventRecorderHolder.class);
    private static final String JFR_ENABLED_KEY = "com.grinderwolf.swm.internal.lettuce.core.jfr";
    private static final boolean JFR_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get("com.grinderwolf.swm.internal.lettuce.core.jfr", "true"));
    static final EventRecorder EVENT_RECORDER;

    EventRecorderHolder() {
    }

    static {
        boolean available = LettuceClassUtils.isPresent("jdk.jfr.Event");
        EventRecorder eventRecorder = NoOpEventRecorder.INSTANCE;
        if (available) {
            if (JFR_ENABLED) {
                logger.debug("Starting with JFR support");
                eventRecorder = new JfrEventRecorder();
            } else {
                logger.debug(String.format("Starting without optional JFR support. JFR use is disabled via System properties (%s)", JFR_ENABLED_KEY));
            }
        } else {
            logger.debug("Starting without optional JFR support. JFR unavailable.");
        }
        EVENT_RECORDER = eventRecorder;
    }
}

