/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic.support;

import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.ClassTypeInformation;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.GenericArrayTypeInformation;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.GenericTypeResolver;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.ParametrizedTypeInformation;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.ResolvableType;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.TypeInformation;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.TypeVariableTypeInformation;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.WildcardTypeInformation;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TypeDiscoverer<S>
implements TypeInformation<S> {
    private final Type type;
    private final Map<TypeVariable<?>, Type> typeVariableMap;
    private final int hashCode;
    private boolean componentTypeResolved = false;
    private TypeInformation<?> componentType;
    private boolean valueTypeResolved = false;
    private TypeInformation<?> valueType;
    private Class<S> resolvedType;

    protected TypeDiscoverer(Type type, Map<TypeVariable<?>, Type> typeVariableMap) {
        LettuceAssert.notNull((Object)type, "Type must not be null");
        LettuceAssert.notNull(typeVariableMap, "TypeVariableMap must not be null");
        this.type = type;
        this.typeVariableMap = typeVariableMap;
        this.hashCode = 17 + 31 * type.hashCode() + 31 * typeVariableMap.hashCode();
    }

    @Override
    public Map<TypeVariable<?>, Type> getTypeVariableMap() {
        return this.typeVariableMap;
    }

    protected TypeInformation<?> createInfo(Type fieldType) {
        if (fieldType.equals(this.type)) {
            return this;
        }
        if (fieldType instanceof Class) {
            return new ClassTypeInformation((Class)fieldType);
        }
        Class<S> resolveType = this.resolveClass(fieldType);
        HashMap variableMap = new HashMap();
        variableMap.putAll(GenericTypeResolver.getTypeVariableMap(resolveType));
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            TypeVariable<Class<S>>[] typeParameters = resolveType.getTypeParameters();
            Type[] arguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                variableMap.put(typeParameters[i], arguments[i]);
            }
            return new ParametrizedTypeInformation(parameterizedType, this, variableMap);
        }
        if (fieldType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)fieldType;
            return new TypeVariableTypeInformation(variable, this.type, this, variableMap);
        }
        if (fieldType instanceof GenericArrayType) {
            return new GenericArrayTypeInformation((GenericArrayType)fieldType, this, variableMap);
        }
        if (fieldType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)fieldType;
            return new WildcardTypeInformation(wildcardType, variableMap);
        }
        throw new IllegalArgumentException();
    }

    protected Class<S> resolveClass(Type type) {
        HashMap<TypeVariable, Type> map = new HashMap<TypeVariable, Type>();
        map.putAll(this.getTypeVariableMap());
        return ResolvableType.forType(type, new TypeVariableMapVariableResolver(map)).resolve(Object.class);
    }

    protected Type resolveType(Type type) {
        HashMap<TypeVariable, Type> map = new HashMap<TypeVariable, Type>();
        map.putAll(this.getTypeVariableMap());
        return ResolvableType.forType(type, new TypeVariableMapVariableResolver(map)).getType();
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Constructor<?> constructor) {
        LettuceAssert.notNull(constructor, "Constructor must not be null!");
        Type[] types = constructor.getGenericParameterTypes();
        ArrayList result = new ArrayList(types.length);
        for (Type parameterType : types) {
            result.add(this.createInfo(parameterType));
        }
        return result;
    }

    @Override
    public Class<S> getType() {
        if (this.resolvedType == null) {
            this.resolvedType = this.resolveClass(this.type);
        }
        return this.resolvedType;
    }

    @Override
    public Type getGenericType() {
        return this.resolveType(this.type);
    }

    @Override
    public ClassTypeInformation<?> getRawTypeInformation() {
        return ClassTypeInformation.from(this.getType()).getRawTypeInformation();
    }

    @Override
    public TypeInformation<?> getActualType() {
        if (this.isMap()) {
            return this.getMapValueType();
        }
        if (this.isCollectionLike()) {
            return this.getComponentType();
        }
        return this;
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Override
    public TypeInformation<?> getMapValueType() {
        if (!this.valueTypeResolved) {
            this.valueType = this.doGetMapValueType();
            this.valueTypeResolved = true;
        }
        return this.valueType;
    }

    protected TypeInformation<?> doGetMapValueType() {
        if (this.isMap()) {
            return this.getTypeArgument(Map.class, 1);
        }
        List<TypeInformation<?>> arguments = this.getTypeArguments();
        if (arguments.size() > 1) {
            return arguments.get(1);
        }
        return null;
    }

    @Override
    public boolean isCollectionLike() {
        Class<S> rawType = this.getType();
        if (rawType.isArray() || Iterable.class.equals(rawType)) {
            return true;
        }
        return Collection.class.isAssignableFrom(rawType);
    }

    @Override
    public final TypeInformation<?> getComponentType() {
        if (!this.componentTypeResolved) {
            this.componentType = this.doGetComponentType();
            this.componentTypeResolved = true;
        }
        return this.componentType;
    }

    protected TypeInformation<?> doGetComponentType() {
        Class<S> rawType = this.getType();
        if (rawType.isArray()) {
            return this.createInfo(rawType.getComponentType());
        }
        if (this.isMap()) {
            return this.getTypeArgument(Map.class, 0);
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            return this.getTypeArgument(Iterable.class, 0);
        }
        List<TypeInformation<?>> arguments = this.getTypeArguments();
        if (arguments.size() > 0) {
            return arguments.get(0);
        }
        return null;
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        return this.createInfo(method.getGenericReturnType());
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Method method) {
        LettuceAssert.notNull((Object)method, "Method most not be null!");
        Type[] types = method.getGenericParameterTypes();
        ArrayList result = new ArrayList(types.length);
        for (Type parameterType : types) {
            result.add(this.createInfo(parameterType));
        }
        return result;
    }

    @Override
    public TypeInformation<?> getSuperTypeInformation(Class<?> superType) {
        Class<S> rawType = this.getType();
        if (!superType.isAssignableFrom(rawType)) {
            return null;
        }
        if (this.getType().equals(superType)) {
            return this;
        }
        ArrayList<Type> candidates = new ArrayList<Type>();
        Type genericSuperclass = rawType.getGenericSuperclass();
        if (genericSuperclass != null) {
            candidates.add(genericSuperclass);
        }
        candidates.addAll(Arrays.asList(rawType.getGenericInterfaces()));
        for (Type candidate : candidates) {
            TypeInformation<S> candidateInfo = this.createInfo(candidate);
            if (superType.equals(candidateInfo.getType())) {
                return candidateInfo;
            }
            TypeInformation<?> nestedSuperType = candidateInfo.getSuperTypeInformation(superType);
            if (nestedSuperType == null) continue;
            return nestedSuperType;
        }
        return null;
    }

    @Override
    public List<TypeInformation<?>> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        return target.getSuperTypeInformation(this.getType()).equals(this);
    }

    public TypeInformation<?> getTypeArgument(Class<?> bound, int index) {
        Class<?>[] arguments = GenericTypeResolver.resolveTypeArguments(this.getType(), bound);
        if (arguments == null) {
            return this.getSuperTypeInformation(bound) instanceof ParametrizedTypeInformation ? ClassTypeInformation.OBJECT : null;
        }
        return this.createInfo(arguments[index]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TypeDiscoverer that = (TypeDiscoverer)obj;
        return this.type.equals(that.type) && this.typeVariableMap.equals(that.typeVariableMap);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static class TypeVariableMapVariableResolver
    implements ResolvableType.VariableResolver {
        private final Map<TypeVariable, Type> typeVariableMap;

        public TypeVariableMapVariableResolver(Map<TypeVariable, Type> typeVariableMap) {
            this.typeVariableMap = typeVariableMap;
        }

        @Override
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            Type type = this.typeVariableMap.get(variable);
            return type != null ? ResolvableType.forType(type) : null;
        }

        @Override
        public Object getSource() {
            return this.typeVariableMap;
        }
    }
}

