/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter;

import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.AnnotationParameterNameDiscoverer;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.ClassTypeInformation;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.CompositeParameterNameDiscoverer;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.MethodParameter;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.ParameterNameDiscoverer;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.StandardReflectionParameterNameDiscoverer;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.TypeInformation;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Parameter {
    private final ParameterNameDiscoverer discoverer = new CompositeParameterNameDiscoverer(new StandardReflectionParameterNameDiscoverer(), new AnnotationParameterNameDiscoverer());
    private final Method method;
    private final String name;
    private final int parameterIndex;
    private final TypeInformation<?> typeInformation;
    private final MethodParameter methodParameter;
    private final Map<Class<? extends Annotation>, Annotation> annotationCache = new ConcurrentHashMap<Class<? extends Annotation>, Annotation>();
    private final Set<Class<? extends Annotation>> absentCache = ConcurrentHashMap.newKeySet();
    private final List<Annotation> annotations;

    public Parameter(Method method, int parameterIndex) {
        this.method = method;
        this.parameterIndex = parameterIndex;
        this.methodParameter = new MethodParameter(method, parameterIndex);
        this.methodParameter.initParameterNameDiscovery(this.discoverer);
        this.name = this.methodParameter.getParameterName();
        this.typeInformation = ClassTypeInformation.fromMethodParameter(method, parameterIndex);
        Annotation[] annotations = method.getParameterAnnotations()[parameterIndex];
        ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(annotations.length);
        for (Annotation annotation : annotations) {
            this.annotationCache.put(annotation.getClass(), annotation);
            allAnnotations.add(annotation);
        }
        this.annotations = Collections.unmodifiableList(allAnnotations);
    }

    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        if (this.absentCache.contains(annotationType)) {
            return null;
        }
        Annotation result = this.annotationCache.computeIfAbsent(annotationType, key -> this.methodParameter.getParameterAnnotation(annotationType));
        if (result == null) {
            this.absentCache.add(annotationType);
        }
        return (A)result;
    }

    public List<? extends Annotation> getAnnotations() {
        return this.annotations;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public Class<?> getParameterType() {
        return this.method.getParameterTypes()[this.parameterIndex];
    }

    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }

    public boolean isAssignableTo(Class<?> target) {
        LettuceAssert.notNull(target, "Target type must not be null");
        return LettuceClassUtils.isAssignable(target, this.getParameterType());
    }

    public boolean isSpecialParameter() {
        return false;
    }

    boolean isBindable() {
        return !this.isSpecialParameter();
    }

    public String getName() {
        return this.name;
    }
}

