/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic.domain;

import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class Timeout {
    private final Duration timeout;

    private Timeout(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout must be greater or equal to zero");
        this.timeout = timeout;
    }

    public static Timeout create(Duration timeout) {
        return new Timeout(timeout);
    }

    public static Timeout create(long timeout, TimeUnit timeUnit) {
        LettuceAssert.notNull((Object)timeUnit, "TimeUnit must not be null");
        return new Timeout(Duration.ofNanos(timeUnit.toNanos(timeout)));
    }

    public Duration getTimeout() {
        return this.timeout;
    }
}

