/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic;

import com.grinderwolf.swm.internal.lettuce.core.api.StatefulConnection;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.BatchTasks;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.Batcher;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.batch.CommandBatching;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RedisCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

class SimpleBatcher
implements Batcher {
    private final StatefulConnection<Object, Object> connection;
    private final int batchSize;
    private final BlockingQueue<RedisCommand<Object, Object, Object>> queue = new LinkedBlockingQueue<RedisCommand<Object, Object, Object>>();
    private final AtomicBoolean flushing = new AtomicBoolean();

    public SimpleBatcher(StatefulConnection<Object, Object> connection, int batchSize) {
        LettuceAssert.isTrue(batchSize == -1 || batchSize > 1, "Batch size must be greater zero or -1");
        this.connection = connection;
        this.batchSize = batchSize;
    }

    @Override
    public BatchTasks batch(RedisCommand<Object, Object, Object> command, CommandBatching batching) {
        this.queue.add(command);
        if (batching == CommandBatching.queue()) {
            return BatchTasks.EMPTY;
        }
        boolean forcedFlush = batching == CommandBatching.flush();
        boolean defaultFlush = false;
        if (!forcedFlush && this.queue.size() >= this.batchSize) {
            defaultFlush = true;
        }
        if (defaultFlush || forcedFlush) {
            return this.flush(forcedFlush);
        }
        return BatchTasks.EMPTY;
    }

    @Override
    public BatchTasks flush() {
        return this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchTasks flush(boolean forcedFlush) {
        boolean defaultFlush = false;
        ArrayList commands = new ArrayList(Math.max(this.batchSize, 10));
        while (this.flushing.compareAndSet(false, true)) {
            try {
                List<? extends RedisCommand<?, ?, ?>> batch;
                long queuedItems;
                int consume = -1;
                if (!forcedFlush && (queuedItems = (long)this.queue.size()) >= (long)this.batchSize) {
                    consume = this.batchSize;
                    defaultFlush = true;
                }
                if ((batch = this.doFlush(forcedFlush, defaultFlush, consume)) != null) {
                    commands.addAll(batch);
                }
                if (defaultFlush && !this.queue.isEmpty() && this.queue.size() > this.batchSize) continue;
                BatchTasks batchTasks = new BatchTasks(commands);
                return batchTasks;
            }
            finally {
                this.flushing.set(false);
            }
        }
        return BatchTasks.EMPTY;
    }

    private List<? extends RedisCommand<?, ?, ?>> doFlush(boolean forcedFlush, boolean defaultFlush, int consume) {
        List<RedisCommand<Object, Object, Object>> commands = null;
        if (forcedFlush) {
            commands = this.prepareForceFlush();
        } else if (defaultFlush) {
            commands = this.prepareDefaultFlush(consume);
        }
        if (commands != null && !commands.isEmpty()) {
            if (commands.size() == 1) {
                this.connection.dispatch(commands.get(0));
            } else {
                this.connection.dispatch(commands);
            }
            return commands;
        }
        return Collections.emptyList();
    }

    private List<RedisCommand<Object, Object, Object>> prepareForceFlush() {
        ArrayList<RedisCommand<Object, Object, Object>> batch = new ArrayList<RedisCommand<Object, Object, Object>>(Math.max(this.batchSize, 10));
        do {
            RedisCommand poll = (RedisCommand)this.queue.poll();
            assert (poll != null);
            batch.add(poll);
        } while (!this.queue.isEmpty());
        return batch;
    }

    private List<RedisCommand<Object, Object, Object>> prepareDefaultFlush(int consume) {
        ArrayList<RedisCommand<Object, Object, Object>> batch = new ArrayList<RedisCommand<Object, Object, Object>>(Math.max(consume, 10));
        while (!(batch.size() >= consume && consume != -1 || this.queue.isEmpty())) {
            RedisCommand poll = (RedisCommand)this.queue.poll();
            assert (poll != null);
            batch.add(poll);
        }
        return batch;
    }
}

