/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic;

import com.grinderwolf.swm.internal.lettuce.core.AbstractRedisReactiveCommands;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandCreationException;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandFactoryResolver;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandMethod;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandMethodVerifier;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ConversionService;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ConvertingCommand;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ExecutableCommand;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ExecutableCommandLookupStrategy;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ReactiveCommandSegmentCommandFactory;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ReactiveExecutableCommand;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ReactiveTypeAdapters;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.RedisCommandsMetadata;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.codec.AnnotationRedisCodecResolver;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.CodecAwareOutputFactoryResolver;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.segment.AnnotationCommandSegmentFactory;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.segment.CommandSegments;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.util.List;

class ReactiveExecutableCommandLookupStrategy
implements ExecutableCommandLookupStrategy {
    private final AbstractRedisReactiveCommands<Object, Object> redisReactiveCommands;
    private final ConversionService conversionService = new ConversionService();
    private final List<RedisCodec<?, ?>> redisCodecs;
    private final CommandOutputFactoryResolver outputFactoryResolver;
    private final ReactiveCommandFactoryResolver commandFactoryResolver;
    private final CommandMethodVerifier commandMethodVerifier;

    ReactiveExecutableCommandLookupStrategy(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver outputFactoryResolver, CommandMethodVerifier commandMethodVerifier, AbstractRedisReactiveCommands<Object, Object> redisReactiveCommands) {
        this.redisReactiveCommands = redisReactiveCommands;
        this.redisCodecs = redisCodecs;
        this.outputFactoryResolver = outputFactoryResolver;
        this.commandMethodVerifier = commandMethodVerifier;
        ReactiveTypeAdapters.registerIn(this.conversionService);
        this.commandFactoryResolver = new ReactiveCommandFactoryResolver();
    }

    @Override
    public ExecutableCommand resolveCommandMethod(CommandMethod method, RedisCommandsMetadata commandsMetadata) {
        LettuceAssert.isTrue(!method.isBatchExecution(), () -> String.format("Command batching %s not supported with ReactiveExecutableCommandLookupStrategy", method));
        LettuceAssert.isTrue(method.isReactiveExecution(), () -> String.format("Command method %s not supported by ReactiveExecutableCommandLookupStrategy", method));
        ReactiveCommandSegmentCommandFactory commandFactory = this.commandFactoryResolver.resolveRedisCommandFactory(method, commandsMetadata);
        return new ConvertingCommand(this.conversionService, new ReactiveExecutableCommand(method, commandFactory, this.redisReactiveCommands));
    }

    class ReactiveCommandFactoryResolver
    implements CommandFactoryResolver {
        final AnnotationCommandSegmentFactory commandSegmentFactory = new AnnotationCommandSegmentFactory();
        final AnnotationRedisCodecResolver codecResolver;

        ReactiveCommandFactoryResolver() {
            this.codecResolver = new AnnotationRedisCodecResolver(ReactiveExecutableCommandLookupStrategy.this.redisCodecs);
        }

        @Override
        public ReactiveCommandSegmentCommandFactory resolveRedisCommandFactory(CommandMethod commandMethod, RedisCommandsMetadata redisCommandsMetadata) {
            RedisCodec<?, ?> codec = this.codecResolver.resolve(commandMethod);
            if (codec == null) {
                throw new CommandCreationException(commandMethod, "Cannot resolve RedisCodec");
            }
            CommandSegments commandSegments = this.commandSegmentFactory.createCommandSegments(commandMethod);
            ReactiveExecutableCommandLookupStrategy.this.commandMethodVerifier.validate(commandSegments, commandMethod);
            CodecAwareOutputFactoryResolver outputFactoryResolver = new CodecAwareOutputFactoryResolver(ReactiveExecutableCommandLookupStrategy.this.outputFactoryResolver, codec);
            return new ReactiveCommandSegmentCommandFactory(commandSegments, commandMethod, codec, outputFactoryResolver);
        }
    }
}

