/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandCreationException;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandMethod;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandSegmentCommandFactory;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ReactiveTypes;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.CommandOutputFactory;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.OutputSelector;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.segment.CommandSegments;

class ReactiveCommandSegmentCommandFactory
extends CommandSegmentCommandFactory {
    private boolean streamingExecution;

    ReactiveCommandSegmentCommandFactory(CommandSegments commandSegments, CommandMethod commandMethod, RedisCodec<?, ?> redisCodec, CommandOutputFactoryResolver outputResolver) {
        super(commandSegments, commandMethod, redisCodec, outputResolver);
        ExecutionSpecificParameters executionAwareParameters;
        if (commandMethod.getParameters() instanceof ExecutionSpecificParameters && (executionAwareParameters = (ExecutionSpecificParameters)commandMethod.getParameters()).hasTimeoutIndex()) {
            throw new CommandCreationException(commandMethod, "Reactive command methods do not support Timeout parameters");
        }
    }

    @Override
    protected CommandOutputFactory resolveCommandOutputFactory(OutputSelector outputSelector) {
        this.streamingExecution = ReactiveTypes.isMultiValueType(outputSelector.getOutputType().getRawClass());
        OutputSelector componentType = new OutputSelector(outputSelector.getOutputType().getGeneric(0), outputSelector.getRedisCodec());
        if (this.streamingExecution) {
            CommandOutputFactory streamingFactory = this.getOutputResolver().resolveStreamingCommandOutput(componentType);
            if (this.streamingExecution && streamingFactory != null) {
                return streamingFactory;
            }
        }
        return super.resolveCommandOutputFactory(componentType);
    }

    boolean isStreamingExecution() {
        return this.streamingExecution;
    }
}

