/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic;

import com.grinderwolf.swm.internal.lettuce.core.GeoCoordinates;
import com.grinderwolf.swm.internal.lettuce.core.KeyValue;
import com.grinderwolf.swm.internal.lettuce.core.Limit;
import com.grinderwolf.swm.internal.lettuce.core.Range;
import com.grinderwolf.swm.internal.lettuce.core.ScoredValue;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.annotation.Key;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.annotation.Value;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.MethodParametersAccessor;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.Parameter;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.Parameters;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class DefaultMethodParametersAccessor
implements MethodParametersAccessor {
    private final Parameters<? extends Parameter> parameters;
    private final List<Object> values;

    DefaultMethodParametersAccessor(Parameters<? extends Parameter> parameters, Object ... values) {
        LettuceAssert.notNull(parameters, "Parameters must not be null");
        LettuceAssert.notNull((Object)values, "Values must not be null");
        this.parameters = parameters;
        this.values = Arrays.asList(values);
    }

    @Override
    public int getParameterCount() {
        return this.parameters.getBindableParameters().size();
    }

    @Override
    public Object getBindableValue(int index) {
        return this.values.get(this.parameters.getBindableParameter(index).getParameterIndex());
    }

    @Override
    public boolean isKey(int index) {
        return this.parameters.getBindableParameter(index).findAnnotation(Key.class) != null;
    }

    @Override
    public boolean isValue(int index) {
        return this.parameters.getBindableParameter(index).findAnnotation(Value.class) != null;
    }

    @Override
    public Iterator<Object> iterator() {
        return new BindableParameterIterator(this);
    }

    @Override
    public int resolveParameterIndex(String name) {
        List<? extends Parameter> bindableParameters = this.parameters.getBindableParameters();
        for (int i = 0; i < bindableParameters.size(); ++i) {
            if (!name.equals(bindableParameters.get(i).getName())) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Cannot resolve named parameter %s", name));
    }

    public Parameters<? extends Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isBindableNullValue(int index) {
        Parameter bindableParameter = this.parameters.getBindableParameter(index);
        return !bindableParameter.isAssignableTo(Limit.class) && !bindableParameter.isAssignableTo(com.grinderwolf.swm.internal.lettuce.core.Value.class) && !bindableParameter.isAssignableTo(KeyValue.class) && !bindableParameter.isAssignableTo(ScoredValue.class) && !bindableParameter.isAssignableTo(GeoCoordinates.class) && !bindableParameter.isAssignableTo(Range.class);
    }

    static class BindableParameterIterator
    implements Iterator<Object> {
        private final int bindableParameterCount;
        private final DefaultMethodParametersAccessor accessor;
        private int currentIndex = 0;

        BindableParameterIterator(DefaultMethodParametersAccessor accessor) {
            LettuceAssert.notNull((Object)accessor, "ParametersParameterAccessor must not be null!");
            this.accessor = accessor;
            this.bindableParameterCount = accessor.getParameters().getBindableParameters().size();
        }

        @Override
        public Object next() {
            return this.accessor.getBindableValue(this.currentIndex++);
        }

        @Override
        public boolean hasNext() {
            return this.bindableParameterCount > this.currentIndex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

