/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic;

import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandMethod;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ReactiveTypes;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.batch.BatchExecutor;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.Parameter;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.Parameters;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.support.ResolvableType;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

public class DeclaredCommandMethod
implements CommandMethod {
    private final Method method;
    private final ResolvableType returnType;
    private final List<Class<?>> arguments = new ArrayList();
    private final ExecutionSpecificParameters parameters;
    private final ResolvableType actualReturnType;
    private final boolean futureExecution;
    private final boolean reactiveExecution;

    private DeclaredCommandMethod(Method method) {
        this(method, new ExecutionSpecificParameters(method));
    }

    private DeclaredCommandMethod(Method method, ExecutionSpecificParameters parameters) {
        ResolvableType[] generics;
        LettuceAssert.notNull((Object)method, "Method must not be null");
        LettuceAssert.notNull((Object)parameters, "Parameters must not be null");
        this.method = method;
        this.returnType = ResolvableType.forMethodReturnType(method);
        this.parameters = parameters;
        this.futureExecution = Future.class.isAssignableFrom(this.getReturnType().getRawClass());
        this.reactiveExecution = ReactiveTypes.supports(this.getReturnType().getRawClass());
        Collections.addAll(this.arguments, method.getParameterTypes());
        ResolvableType actualReturnType = this.returnType;
        while (Future.class.isAssignableFrom(actualReturnType.getRawClass()) && (generics = actualReturnType.getGenerics()).length == 1) {
            actualReturnType = generics[0];
        }
        this.actualReturnType = actualReturnType;
    }

    public static CommandMethod create(Method method) {
        return new DeclaredCommandMethod(method);
    }

    @Override
    public Parameters<? extends Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public ResolvableType getReturnType() {
        return this.returnType;
    }

    @Override
    public ResolvableType getActualReturnType() {
        return this.actualReturnType;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        return this.method.getAnnotation(annotationClass) != null;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isFutureExecution() {
        return this.futureExecution;
    }

    @Override
    public boolean isReactiveExecution() {
        return this.reactiveExecution;
    }

    @Override
    public boolean isBatchExecution() {
        return this.parameters.hasCommandBatchingIndex() || this.method.getName().equals("flush") && this.method.getDeclaringClass().equals(BatchExecutor.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeclaredCommandMethod)) {
            return false;
        }
        DeclaredCommandMethod that = (DeclaredCommandMethod)o;
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(that.arguments) : that.arguments == null;
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.method.toGenericString();
    }
}

