/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CodecAwareMethodParametersAccessor;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandCreationException;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandFactory;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandMethod;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.DefaultMethodParametersAccessor;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ParameterBinder;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.CommandOutputFactory;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.OutputSelector;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.MethodParametersAccessor;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.segment.CommandSegments;
import com.grinderwolf.swm.internal.lettuce.core.output.CommandOutput;
import com.grinderwolf.swm.internal.lettuce.core.protocol.Command;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandArgs;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RedisCommand;

class CommandSegmentCommandFactory
implements CommandFactory {
    private final CommandMethod commandMethod;
    private final CommandSegments segments;
    private final CommandOutputFactoryResolver outputResolver;
    private final RedisCodec<Object, Object> redisCodec;
    private final ParameterBinder parameterBinder = new ParameterBinder();
    private final CommandOutputFactory outputFactory;
    private final CodecAwareMethodParametersAccessor.TypeContext typeContext;

    public CommandSegmentCommandFactory(CommandSegments commandSegments, CommandMethod commandMethod, RedisCodec<?, ?> redisCodec, CommandOutputFactoryResolver outputResolver) {
        this.segments = commandSegments;
        this.commandMethod = commandMethod;
        this.redisCodec = redisCodec;
        this.outputResolver = outputResolver;
        this.typeContext = new CodecAwareMethodParametersAccessor.TypeContext(redisCodec);
        OutputSelector outputSelector = new OutputSelector(commandMethod.getActualReturnType(), redisCodec);
        CommandOutputFactory factory = this.resolveCommandOutputFactory(outputSelector);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Cannot resolve CommandOutput for result type %s on method %s", commandMethod.getActualReturnType(), commandMethod.getMethod()));
        }
        if (commandMethod.getParameters() instanceof ExecutionSpecificParameters) {
            ExecutionSpecificParameters executionAwareParameters = (ExecutionSpecificParameters)commandMethod.getParameters();
            if (commandMethod.isFutureExecution() && executionAwareParameters.hasTimeoutIndex()) {
                throw new CommandCreationException(commandMethod, "Asynchronous command methods do not support Timeout parameters");
            }
        }
        this.outputFactory = factory;
    }

    protected CommandOutputFactoryResolver getOutputResolver() {
        return this.outputResolver;
    }

    protected CommandOutputFactory resolveCommandOutputFactory(OutputSelector outputSelector) {
        return this.outputResolver.resolveCommandOutput(outputSelector);
    }

    @Override
    public RedisCommand<Object, Object, Object> createCommand(Object[] parameters) {
        CodecAwareMethodParametersAccessor parametersAccessor = new CodecAwareMethodParametersAccessor((MethodParametersAccessor)new DefaultMethodParametersAccessor(this.commandMethod.getParameters(), parameters), this.typeContext);
        CommandArgs<Object, Object> args = new CommandArgs<Object, Object>(this.redisCodec);
        CommandOutput<Object, Object, ?> output = this.outputFactory.create(this.redisCodec);
        Command<Object, Object, Object> command = new Command<Object, Object, Object>(this.segments.getCommandType(), output, args);
        this.parameterBinder.bind(args, this.redisCodec, this.segments, parametersAccessor);
        return command;
    }
}

