/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic;

import com.grinderwolf.swm.internal.lettuce.core.api.StatefulConnection;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.AsyncExecutableCommand;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandFactory;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandMethod;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandMethodVerifier;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ExecutableCommand;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ExecutableCommandLookupStrategySupport;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.RedisCommandsMetadata;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.output.CommandOutputFactoryResolver;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.util.List;

class AsyncExecutableCommandLookupStrategy
extends ExecutableCommandLookupStrategySupport {
    private final StatefulConnection<Object, Object> connection;

    public AsyncExecutableCommandLookupStrategy(List<RedisCodec<?, ?>> redisCodecs, CommandOutputFactoryResolver commandOutputFactoryResolver, CommandMethodVerifier commandMethodVerifier, StatefulConnection<Object, Object> connection) {
        super(redisCodecs, commandOutputFactoryResolver, commandMethodVerifier);
        this.connection = connection;
    }

    @Override
    public ExecutableCommand resolveCommandMethod(CommandMethod method, RedisCommandsMetadata metadata) {
        LettuceAssert.isTrue(!method.isReactiveExecution(), () -> String.format("Command method %s not supported by this command lookup strategy", method));
        CommandFactory commandFactory = super.resolveCommandFactory(method, metadata);
        return new AsyncExecutableCommand(method, commandFactory, this.connection);
    }
}

