/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.dynamic;

import com.grinderwolf.swm.internal.lettuce.core.api.StatefulConnection;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandFactory;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.CommandMethod;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.ExecutableCommand;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.domain.Timeout;
import com.grinderwolf.swm.internal.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import com.grinderwolf.swm.internal.lettuce.core.internal.Futures;
import com.grinderwolf.swm.internal.lettuce.core.protocol.AsyncCommand;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RedisCommand;
import java.time.Duration;
import java.util.concurrent.ExecutionException;

class AsyncExecutableCommand
implements ExecutableCommand {
    private final CommandMethod commandMethod;
    private final CommandFactory commandFactory;
    private final StatefulConnection<Object, Object> connection;

    AsyncExecutableCommand(CommandMethod commandMethod, CommandFactory commandFactory, StatefulConnection<Object, Object> connection) {
        this.commandMethod = commandMethod;
        this.commandFactory = commandFactory;
        this.connection = connection;
    }

    @Override
    public Object execute(Object[] parameters) throws ExecutionException, InterruptedException {
        RedisCommand<Object, Object, Object> command = this.commandFactory.createCommand(parameters);
        return this.dispatchCommand(parameters, command);
    }

    protected Object dispatchCommand(Object[] arguments, RedisCommand<Object, Object, Object> command) throws InterruptedException, ExecutionException {
        Timeout timeoutArg;
        ExecutionSpecificParameters executionSpecificParameters;
        AsyncCommand<Object, Object, Object> asyncCommand = new AsyncCommand<Object, Object, Object>(command);
        if (this.commandMethod.isFutureExecution()) {
            RedisCommand<Object, Object, Object> dispatched = this.connection.dispatch(asyncCommand);
            if (dispatched instanceof AsyncCommand) {
                return dispatched;
            }
            return asyncCommand;
        }
        this.connection.dispatch(asyncCommand);
        Duration timeout = this.connection.getTimeout();
        if (this.commandMethod.getParameters() instanceof ExecutionSpecificParameters && (executionSpecificParameters = (ExecutionSpecificParameters)this.commandMethod.getParameters()).hasTimeoutIndex() && (timeoutArg = (Timeout)arguments[executionSpecificParameters.getTimeoutIndex()]) != null) {
            timeout = timeoutArg.getTimeout();
        }
        Futures.await(timeout, asyncCommand);
        return asyncCommand.get();
    }

    @Override
    public CommandMethod getCommandMethod() {
        return this.commandMethod;
    }
}

