/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.codec;

import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.codec.ToByteBufEncoder;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class StringCodec
implements RedisCodec<String, String>,
ToByteBufEncoder<String, String> {
    public static final StringCodec UTF8 = new StringCodec(StandardCharsets.UTF_8);
    public static final StringCodec ASCII = new StringCodec(StandardCharsets.US_ASCII);
    private static final byte[] EMPTY = new byte[0];
    private final Charset charset;
    private final float averageBytesPerChar;
    private final float maxBytesPerChar;
    private final boolean ascii;
    private final boolean utf8;

    public StringCodec() {
        this(Charset.defaultCharset());
    }

    public StringCodec(Charset charset) {
        LettuceAssert.notNull((Object)charset, "Charset must not be null");
        this.charset = charset;
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        this.averageBytesPerChar = encoder.averageBytesPerChar();
        this.maxBytesPerChar = encoder.maxBytesPerChar();
        if (charset.name().equals("UTF-8")) {
            this.utf8 = true;
            this.ascii = false;
        } else if (charset.name().contains("ASCII")) {
            this.utf8 = false;
            this.ascii = true;
        } else {
            this.ascii = false;
            this.utf8 = false;
        }
    }

    @Override
    public void encodeKey(String key, ByteBuf target) {
        this.encode(key, target);
    }

    @Override
    public int estimateSize(Object keyOrValue) {
        if (keyOrValue instanceof String) {
            return this.sizeOf((String)keyOrValue, true);
        }
        return 0;
    }

    @Override
    public void encodeValue(String value, ByteBuf target) {
        this.encode(value, target);
    }

    @Override
    public String decodeKey(ByteBuffer bytes) {
        return Unpooled.wrappedBuffer(bytes).toString(this.charset);
    }

    @Override
    public String decodeValue(ByteBuffer bytes) {
        return Unpooled.wrappedBuffer(bytes).toString(this.charset);
    }

    @Override
    public ByteBuffer encodeKey(String key) {
        return this.encodeAndAllocateBuffer(key);
    }

    @Override
    public ByteBuffer encodeValue(String value) {
        return this.encodeAndAllocateBuffer(value);
    }

    private ByteBuffer encodeAndAllocateBuffer(String key) {
        if (key == null) {
            return ByteBuffer.wrap(EMPTY);
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.sizeOf(key, false));
        ByteBuf byteBuf = Unpooled.wrappedBuffer(buffer);
        byteBuf.clear();
        this.encode(key, byteBuf);
        buffer.limit(byteBuf.writerIndex());
        return buffer;
    }

    public void encode(String str, ByteBuf target) {
        if (str == null) {
            return;
        }
        if (this.utf8) {
            ByteBufUtil.writeUtf8(target, (CharSequence)str);
            return;
        }
        if (this.ascii) {
            ByteBufUtil.writeAscii(target, (CharSequence)str);
            return;
        }
        CharsetEncoder encoder = CharsetUtil.encoder(this.charset);
        int length = this.sizeOf(str, false);
        target.ensureWritable(length);
        try {
            ByteBuffer dstBuf = target.nioBuffer(0, length);
            int pos = dstBuf.position();
            CoderResult cr = encoder.encode(CharBuffer.wrap(str), dstBuf, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = encoder.flush(dstBuf)).isUnderflow()) {
                cr.throwException();
            }
            target.writerIndex(target.writerIndex() + dstBuf.position() - pos);
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
    }

    int sizeOf(String value, boolean estimate) {
        if (this.utf8) {
            return ByteBufUtil.utf8MaxBytes(value);
        }
        if (this.ascii) {
            return value.length();
        }
        if (estimate) {
            return (int)this.averageBytesPerChar * value.length();
        }
        return (int)this.maxBytesPerChar * value.length();
    }
}

