/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.cluster.topology;

import com.grinderwolf.swm.internal.lettuce.core.protocol.AsyncCommand;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;

class TimedAsyncCommand<K, V, T>
extends AsyncCommand<K, V, T> {
    long encodedAtNs = -1L;
    long completedAtNs = -1L;

    public TimedAsyncCommand(RedisCommand<K, V, T> command) {
        super(command);
    }

    @Override
    public void encode(ByteBuf buf) {
        this.completedAtNs = -1L;
        this.encodedAtNs = -1L;
        super.encode(buf);
        this.encodedAtNs = System.nanoTime();
    }

    @Override
    public void complete() {
        this.completedAtNs = System.nanoTime();
        super.complete();
    }

    public long duration() {
        if (this.completedAtNs == -1L || this.encodedAtNs == -1L) {
            return -1L;
        }
        return this.completedAtNs - this.encodedAtNs;
    }
}

