/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.cluster.topology;

import com.grinderwolf.swm.internal.lettuce.core.RedisFuture;
import com.grinderwolf.swm.internal.lettuce.core.RedisURI;
import com.grinderwolf.swm.internal.lettuce.core.cluster.models.partitions.ClusterPartitionParser;
import com.grinderwolf.swm.internal.lettuce.core.cluster.models.partitions.Partitions;
import com.grinderwolf.swm.internal.lettuce.core.cluster.models.partitions.RedisClusterNode;
import com.grinderwolf.swm.internal.lettuce.core.cluster.topology.Requests;
import com.grinderwolf.swm.internal.lettuce.core.cluster.topology.TimedAsyncCommand;
import com.grinderwolf.swm.internal.lettuce.core.cluster.topology.TopologyComparators;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

class NodeTopologyView {
    private final boolean available;
    private final RedisURI redisURI;
    private Partitions partitions;
    private final int connectedClients;
    private final long replicationOffset;
    private final long latency;
    private final String clusterNodes;
    private final String info;

    private NodeTopologyView(RedisURI redisURI) {
        this.available = false;
        this.redisURI = redisURI;
        this.partitions = new Partitions();
        this.connectedClients = 0;
        this.replicationOffset = -1L;
        this.clusterNodes = null;
        this.info = null;
        this.latency = 0L;
    }

    NodeTopologyView(RedisURI redisURI, String clusterNodes, String info2, long latency) {
        this.available = true;
        this.redisURI = redisURI;
        Properties properties = info2 == null ? new Properties() : NodeTopologyView.parseInfo(info2);
        this.partitions = ClusterPartitionParser.parse(clusterNodes);
        this.connectedClients = this.getClientCount(properties);
        this.replicationOffset = this.getReplicationOffset(properties);
        this.clusterNodes = clusterNodes;
        this.info = info2;
        this.latency = latency;
    }

    private int getClientCount(Properties properties) {
        return Integer.parseInt(properties.getProperty("connected_clients", "0"));
    }

    private long getReplicationOffset(Properties properties) {
        return Long.parseLong(properties.getProperty("master_repl_offset", "-1"));
    }

    static NodeTopologyView from(RedisURI redisURI, Requests clusterNodesRequests, Requests infoRequests) {
        TimedAsyncCommand<String, String, String> nodes = clusterNodesRequests.getRequest(redisURI);
        TimedAsyncCommand<String, String, String> info2 = infoRequests.getRequest(redisURI);
        if (NodeTopologyView.resultAvailable(nodes) && !nodes.isCompletedExceptionally() && NodeTopologyView.resultAvailable(info2)) {
            return new NodeTopologyView(redisURI, (String)nodes.join(), NodeTopologyView.optionallyGet(info2), nodes.duration());
        }
        return new NodeTopologyView(redisURI);
    }

    private static <T> T optionallyGet(TimedAsyncCommand<?, ?, T> command) {
        if (command.isCompletedExceptionally()) {
            return null;
        }
        return command.join();
    }

    private static boolean resultAvailable(RedisFuture<?> redisFuture) {
        return redisFuture != null && redisFuture.isDone() && !redisFuture.isCancelled();
    }

    private static Properties parseInfo(String info2) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(info2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    String getNodeId() {
        return this.getOwnPartition().getNodeId();
    }

    RedisURI getRedisURI() {
        if (this.partitions.isEmpty()) {
            return this.redisURI;
        }
        return this.getOwnPartition().getUri();
    }

    RedisClusterNode getOwnPartition() {
        RedisClusterNode own = this.findOwnPartition();
        if (own != null) {
            return own;
        }
        throw new IllegalStateException("Cannot determine own partition");
    }

    private RedisClusterNode findOwnPartition() {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.is(RedisClusterNode.NodeFlag.MYSELF)) continue;
            return partition;
        }
        return null;
    }

    void postProcessPartitions() {
        TopologyComparators.SortAction sortAction = TopologyComparators.SortAction.getSortAction();
        sortAction.sort(this.getPartitions());
        this.getPartitions().updateCache();
    }

    public boolean canContribute() {
        RedisClusterNode ownPartition = this.findOwnPartition();
        return ownPartition != null;
    }

    long getLatency() {
        return this.latency;
    }

    boolean isAvailable() {
        return this.available;
    }

    Partitions getPartitions() {
        return this.partitions;
    }

    int getConnectedClients() {
        return this.connectedClients;
    }

    long getReplicationOffset() {
        return this.replicationOffset;
    }

    String getInfo() {
        return this.info;
    }

    String getClusterNodes() {
        return this.clusterNodes;
    }

    void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }
}

