/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.cluster;

import com.grinderwolf.swm.internal.lettuce.core.GeoArgs;
import com.grinderwolf.swm.internal.lettuce.core.GeoWithin;
import com.grinderwolf.swm.internal.lettuce.core.RedisFuture;
import com.grinderwolf.swm.internal.lettuce.core.RedisURI;
import com.grinderwolf.swm.internal.lettuce.core.cluster.AbstractNodeSelection;
import com.grinderwolf.swm.internal.lettuce.core.cluster.AsyncClusterConnectionProvider;
import com.grinderwolf.swm.internal.lettuce.core.cluster.ClusterDistributionChannelWriter;
import com.grinderwolf.swm.internal.lettuce.core.cluster.NodeSelectionInvocationHandler;
import com.grinderwolf.swm.internal.lettuce.core.cluster.StatefulRedisClusterPubSubConnectionImpl;
import com.grinderwolf.swm.internal.lettuce.core.cluster.api.NodeSelectionSupport;
import com.grinderwolf.swm.internal.lettuce.core.cluster.models.partitions.RedisClusterNode;
import com.grinderwolf.swm.internal.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import com.grinderwolf.swm.internal.lettuce.core.cluster.pubsub.api.async.NodeSelectionPubSubAsyncCommands;
import com.grinderwolf.swm.internal.lettuce.core.cluster.pubsub.api.async.PubSubAsyncNodeSelection;
import com.grinderwolf.swm.internal.lettuce.core.cluster.pubsub.api.async.RedisClusterPubSubAsyncCommands;
import com.grinderwolf.swm.internal.lettuce.core.codec.RedisCodec;
import com.grinderwolf.swm.internal.lettuce.core.protocol.ConnectionIntent;
import com.grinderwolf.swm.internal.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl;
import com.grinderwolf.swm.internal.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import com.grinderwolf.swm.internal.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RedisClusterPubSubAsyncCommandsImpl<K, V>
extends RedisPubSubAsyncCommandsImpl<K, V>
implements RedisClusterPubSubAsyncCommands<K, V> {
    public RedisClusterPubSubAsyncCommandsImpl(StatefulRedisPubSubConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
    }

    @Override
    public RedisFuture<Set<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return super.georadius_ro(key, longitude, latitude, distance, unit);
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return super.georadius_ro(key, longitude, latitude, distance, unit, geoArgs);
    }

    @Override
    public RedisFuture<Set<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        return super.georadiusbymember_ro(key, member, distance, unit);
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return super.georadiusbymember_ro(key, member, distance, unit, geoArgs);
    }

    @Override
    public StatefulRedisClusterPubSubConnectionImpl<K, V> getStatefulConnection() {
        return (StatefulRedisClusterPubSubConnectionImpl)super.getStatefulConnection();
    }

    @Override
    public PubSubAsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> predicate) {
        StaticPubSubAsyncNodeSelection selection = new StaticPubSubAsyncNodeSelection(this.getStatefulConnection(), predicate);
        NodeSelectionInvocationHandler h = new NodeSelectionInvocationHandler((AbstractNodeSelection)selection, RedisPubSubAsyncCommands.class, NodeSelectionInvocationHandler.ExecutionModel.ASYNC);
        return (PubSubAsyncNodeSelection)Proxy.newProxyInstance(NodeSelectionSupport.class.getClassLoader(), new Class[]{NodeSelectionPubSubAsyncCommands.class, PubSubAsyncNodeSelection.class}, (InvocationHandler)h);
    }

    private static class StaticPubSubAsyncNodeSelection<K, V>
    extends AbstractNodeSelection<RedisPubSubAsyncCommands<K, V>, NodeSelectionPubSubAsyncCommands<K, V>, K, V>
    implements PubSubAsyncNodeSelection<K, V> {
        private final List<RedisClusterNode> redisClusterNodes;
        private final ClusterDistributionChannelWriter writer;

        public StaticPubSubAsyncNodeSelection(StatefulRedisClusterPubSubConnection<K, V> globalConnection, Predicate<RedisClusterNode> selector) {
            this.redisClusterNodes = globalConnection.getPartitions().stream().filter(selector).collect(Collectors.toList());
            this.writer = ((StatefulRedisClusterPubSubConnectionImpl)globalConnection).getClusterDistributionChannelWriter();
        }

        @Override
        protected CompletableFuture<RedisPubSubAsyncCommands<K, V>> getApi(RedisClusterNode redisClusterNode) {
            return this.getConnection(redisClusterNode).thenApply(StatefulRedisPubSubConnection::async);
        }

        @Override
        protected List<RedisClusterNode> nodes() {
            return this.redisClusterNodes;
        }

        @Override
        protected CompletableFuture<StatefulRedisPubSubConnection<K, V>> getConnection(RedisClusterNode redisClusterNode) {
            RedisURI uri = redisClusterNode.getUri();
            AsyncClusterConnectionProvider async = (AsyncClusterConnectionProvider)((Object)this.writer.getClusterConnectionProvider());
            return async.getConnectionAsync(ConnectionIntent.WRITE, uri.getHost(), uri.getPort()).thenApply(it -> (StatefulRedisPubSubConnection)it);
        }
    }
}

