/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.cluster;

import com.grinderwolf.swm.internal.lettuce.core.RedisURI;
import com.grinderwolf.swm.internal.lettuce.core.cluster.PartitionsConsensus;
import com.grinderwolf.swm.internal.lettuce.core.cluster.models.partitions.Partitions;
import com.grinderwolf.swm.internal.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

class PartitionsConsensusImpl {
    PartitionsConsensusImpl() {
    }

    static final class VotedPartitions {
        final int votes;
        final Partitions partitions;

        public VotedPartitions(int votes, Partitions partitions) {
            this.votes = votes;
            this.partitions = partitions;
        }
    }

    static final class HealthyMajority
    extends PartitionsConsensus {
        HealthyMajority() {
        }

        @Override
        Partitions getPartitions(Partitions current, Map<RedisURI, Partitions> topologyViews) {
            if (topologyViews.isEmpty()) {
                return current;
            }
            ArrayList<VotedPartitions> votedList = new ArrayList<VotedPartitions>();
            for (Partitions partitions : topologyViews.values()) {
                int votes = 0;
                for (RedisClusterNode node : partitions) {
                    if (node.is(RedisClusterNode.NodeFlag.FAIL) || node.is(RedisClusterNode.NodeFlag.EVENTUAL_FAIL) || node.is(RedisClusterNode.NodeFlag.NOADDR)) continue;
                    ++votes;
                }
                votedList.add(new VotedPartitions(votes, partitions));
            }
            Collections.shuffle(votedList);
            Collections.sort(votedList, (o1, o2) -> Integer.compare(o2.votes, o1.votes));
            return ((VotedPartitions)votedList.get((int)0)).partitions;
        }
    }

    static final class KnownMajority
    extends PartitionsConsensus {
        KnownMajority() {
        }

        @Override
        Partitions getPartitions(Partitions current, Map<RedisURI, Partitions> topologyViews) {
            if (topologyViews.isEmpty()) {
                return current;
            }
            ArrayList<VotedPartitions> votedList = new ArrayList<VotedPartitions>();
            for (Partitions partitions : topologyViews.values()) {
                int knownNodes = 0;
                for (RedisClusterNode knownNode : current) {
                    if (partitions.getPartitionByNodeId(knownNode.getNodeId()) == null) continue;
                    ++knownNodes;
                }
                votedList.add(new VotedPartitions(knownNodes, partitions));
            }
            Collections.shuffle(votedList);
            Collections.sort(votedList, (o1, o2) -> Integer.compare(o2.votes, o1.votes));
            return ((VotedPartitions)votedList.get((int)0)).partitions;
        }
    }
}

