/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.cluster;

import com.grinderwolf.swm.internal.lettuce.core.RedisURI;
import com.grinderwolf.swm.internal.lettuce.core.api.StatefulRedisConnection;
import com.grinderwolf.swm.internal.lettuce.core.cluster.AbstractNodeSelection;
import com.grinderwolf.swm.internal.lettuce.core.cluster.AsyncClusterConnectionProvider;
import com.grinderwolf.swm.internal.lettuce.core.cluster.ClusterDistributionChannelWriter;
import com.grinderwolf.swm.internal.lettuce.core.cluster.models.partitions.RedisClusterNode;
import com.grinderwolf.swm.internal.lettuce.core.protocol.ConnectionIntent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class DynamicNodeSelection<API, CMD, K, V>
extends AbstractNodeSelection<API, CMD, K, V> {
    private final ClusterDistributionChannelWriter writer;
    private final Predicate<RedisClusterNode> selector;
    private final ConnectionIntent connectionIntent;
    private final Function<StatefulRedisConnection<K, V>, API> apiExtractor;

    public DynamicNodeSelection(ClusterDistributionChannelWriter writer, Predicate<RedisClusterNode> selector, ConnectionIntent connectionIntent, Function<StatefulRedisConnection<K, V>, API> apiExtractor) {
        this.selector = selector;
        this.connectionIntent = connectionIntent;
        this.writer = writer;
        this.apiExtractor = apiExtractor;
    }

    @Override
    protected CompletableFuture<StatefulRedisConnection<K, V>> getConnection(RedisClusterNode redisClusterNode) {
        RedisURI uri = redisClusterNode.getUri();
        AsyncClusterConnectionProvider async = (AsyncClusterConnectionProvider)((Object)this.writer.getClusterConnectionProvider());
        return async.getConnectionAsync(this.connectionIntent, uri.getHost(), uri.getPort());
    }

    @Override
    protected CompletableFuture<API> getApi(RedisClusterNode redisClusterNode) {
        return this.getConnection(redisClusterNode).thenApply(this.apiExtractor);
    }

    @Override
    protected List<RedisClusterNode> nodes() {
        return this.writer.getPartitions().stream().filter(this.selector).collect(Collectors.toList());
    }
}

