/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core.cluster;

import com.grinderwolf.swm.internal.lettuce.core.ClientOptions;
import com.grinderwolf.swm.internal.lettuce.core.CommandListenerWriter;
import com.grinderwolf.swm.internal.lettuce.core.ReadFrom;
import com.grinderwolf.swm.internal.lettuce.core.RedisChannelHandler;
import com.grinderwolf.swm.internal.lettuce.core.RedisChannelWriter;
import com.grinderwolf.swm.internal.lettuce.core.RedisException;
import com.grinderwolf.swm.internal.lettuce.core.api.StatefulRedisConnection;
import com.grinderwolf.swm.internal.lettuce.core.cluster.AsyncClusterConnectionProvider;
import com.grinderwolf.swm.internal.lettuce.core.cluster.ClusterClientOptions;
import com.grinderwolf.swm.internal.lettuce.core.cluster.ClusterCommand;
import com.grinderwolf.swm.internal.lettuce.core.cluster.ClusterConnectionProvider;
import com.grinderwolf.swm.internal.lettuce.core.cluster.ClusterEventListener;
import com.grinderwolf.swm.internal.lettuce.core.cluster.ReadOnlyCommands;
import com.grinderwolf.swm.internal.lettuce.core.cluster.SlotHash;
import com.grinderwolf.swm.internal.lettuce.core.cluster.event.AskRedirectionEvent;
import com.grinderwolf.swm.internal.lettuce.core.cluster.event.MovedRedirectionEvent;
import com.grinderwolf.swm.internal.lettuce.core.cluster.models.partitions.Partitions;
import com.grinderwolf.swm.internal.lettuce.core.codec.StringCodec;
import com.grinderwolf.swm.internal.lettuce.core.event.Event;
import com.grinderwolf.swm.internal.lettuce.core.internal.Futures;
import com.grinderwolf.swm.internal.lettuce.core.internal.HostAndPort;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.output.StatusOutput;
import com.grinderwolf.swm.internal.lettuce.core.protocol.Command;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandArgs;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandExpiryWriter;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandKeyword;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandType;
import com.grinderwolf.swm.internal.lettuce.core.protocol.ConnectionFacade;
import com.grinderwolf.swm.internal.lettuce.core.protocol.ConnectionIntent;
import com.grinderwolf.swm.internal.lettuce.core.protocol.DefaultEndpoint;
import com.grinderwolf.swm.internal.lettuce.core.protocol.ProtocolKeyword;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RedisCommand;
import com.grinderwolf.swm.internal.lettuce.core.resource.ClientResources;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;

class ClusterDistributionChannelWriter
implements RedisChannelWriter {
    private final RedisChannelWriter defaultWriter;
    private final ClusterEventListener clusterEventListener;
    private final int executionLimit;
    private ClusterConnectionProvider clusterConnectionProvider;
    private AsyncClusterConnectionProvider asyncClusterConnectionProvider;
    private boolean closed = false;
    private volatile Partitions partitions;

    ClusterDistributionChannelWriter(RedisChannelWriter defaultWriter, ClientOptions clientOptions, ClusterEventListener clusterEventListener) {
        this.executionLimit = clientOptions instanceof ClusterClientOptions ? ((ClusterClientOptions)clientOptions).getMaxRedirects() : 5;
        this.defaultWriter = defaultWriter;
        this.clusterEventListener = clusterEventListener;
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "Command must not be null");
        if (this.closed) {
            command.completeExceptionally(new RedisException("Connection is closed"));
            return command;
        }
        return this.doWrite(command);
    }

    private <K, V, T> RedisCommand<K, V, T> doWrite(RedisCommand<K, V, T> command) {
        ByteBuffer encodedKey;
        ClusterCommand clusterCommand;
        if (command instanceof ClusterCommand && !command.isDone() && ((clusterCommand = (ClusterCommand)command).isMoved() || clusterCommand.isAsk())) {
            boolean asking;
            HostAndPort target;
            ByteBuffer firstEncodedKey = clusterCommand.getArgs().getFirstEncodedKey();
            String keyAsString = null;
            int slot = -1;
            if (firstEncodedKey != null) {
                firstEncodedKey.mark();
                keyAsString = StringCodec.UTF8.decodeKey(firstEncodedKey);
                firstEncodedKey.reset();
                slot = SlotHash.getSlot(firstEncodedKey);
            }
            if (clusterCommand.isMoved()) {
                target = ClusterDistributionChannelWriter.getMoveTarget(clusterCommand.getError());
                this.clusterEventListener.onMovedRedirection();
                asking = false;
                this.publish(new MovedRedirectionEvent(clusterCommand.getType().name(), keyAsString, slot, clusterCommand.getError()));
            } else {
                target = ClusterDistributionChannelWriter.getAskTarget(clusterCommand.getError());
                asking = true;
                this.clusterEventListener.onAskRedirection();
                this.publish(new AskRedirectionEvent(clusterCommand.getType().name(), keyAsString, slot, clusterCommand.getError()));
            }
            command.getOutput().setError((String)null);
            CompletableFuture connectFuture = this.asyncClusterConnectionProvider.getConnectionAsync(ConnectionIntent.WRITE, target.getHostText(), target.getPort());
            if (ClusterDistributionChannelWriter.isSuccessfullyCompleted(connectFuture)) {
                ClusterDistributionChannelWriter.writeCommand(command, asking, connectFuture.join(), null);
            } else {
                connectFuture.whenComplete((connection, throwable) -> ClusterDistributionChannelWriter.writeCommand(command, asking, connection, throwable));
            }
            return command;
        }
        ClusterCommand commandToSend = this.getCommandToSend(command);
        CommandArgs<K, V> args = command.getArgs();
        if (args != null && !CommandType.CLIENT.equals(commandToSend.getType()) && (encodedKey = args.getFirstEncodedKey()) != null) {
            int hash = SlotHash.getSlot(encodedKey);
            ConnectionIntent connectionIntent = ClusterDistributionChannelWriter.getIntent(command.getType());
            CompletableFuture connectFuture = ((AsyncClusterConnectionProvider)((Object)this.clusterConnectionProvider)).getConnectionAsync(connectionIntent, hash);
            if (ClusterDistributionChannelWriter.isSuccessfullyCompleted(connectFuture)) {
                ClusterDistributionChannelWriter.writeCommand(commandToSend, false, connectFuture.join(), null);
            } else {
                connectFuture.whenComplete((connection, throwable) -> ClusterDistributionChannelWriter.writeCommand(commandToSend, false, connection, throwable));
            }
            return commandToSend;
        }
        ClusterDistributionChannelWriter.writeCommand(commandToSend, this.defaultWriter);
        return commandToSend;
    }

    private void publish(Event event) {
        ClientResources clientResources = this.getClientResources();
        if (clientResources != null) {
            clientResources.eventBus().publish(event);
        }
    }

    private static boolean isSuccessfullyCompleted(CompletableFuture<?> connectFuture) {
        return connectFuture.isDone() && !connectFuture.isCompletedExceptionally();
    }

    private <K, V, T> ClusterCommand<K, V, T> getCommandToSend(RedisCommand<K, V, T> command) {
        if (command instanceof ClusterCommand) {
            return (ClusterCommand)command;
        }
        return new ClusterCommand<K, V, T>(command, this, this.executionLimit);
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, boolean asking, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            command.completeExceptionally(throwable);
            return;
        }
        try {
            if (asking) {
                ClusterDistributionChannelWriter.writeCommands(Arrays.asList(ClusterDistributionChannelWriter.asking(), command), ((RedisChannelHandler)((Object)connection)).getChannelWriter());
            } else {
                ClusterDistributionChannelWriter.writeCommand(command, ((RedisChannelHandler)((Object)connection)).getChannelWriter());
            }
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    private static <V, K> RedisCommand<K, V, ?> asking() {
        return new Command(CommandType.ASKING, new StatusOutput<String, String>(StringCodec.ASCII), new CommandArgs<String, String>(StringCodec.ASCII));
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, RedisChannelWriter writer) {
        try {
            ClusterDistributionChannelWriter.getWriterToUse(writer).write(command);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    private static <K, V> void writeCommands(Collection<RedisCommand<K, V, ?>> commands, RedisChannelWriter writer) {
        try {
            ClusterDistributionChannelWriter.getWriterToUse(writer).write(commands);
        }
        catch (Exception e) {
            commands.forEach(command -> command.completeExceptionally(e));
        }
    }

    private static RedisChannelWriter getWriterToUse(RedisChannelWriter writer) {
        RedisChannelWriter writerToUse = writer;
        if (writer instanceof ClusterDistributionChannelWriter) {
            writerToUse = ((ClusterDistributionChannelWriter)writer).defaultWriter;
        }
        return writerToUse;
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> commands) {
        LettuceAssert.notNull(commands, "Commands must not be null");
        if (this.closed) {
            commands.forEach(it -> it.completeExceptionally(new RedisException("Connection is closed")));
            return commands;
        }
        ArrayList<ClusterCommand> clusterCommands = new ArrayList<ClusterCommand>(commands.size());
        ArrayList defaultCommands = new ArrayList(commands.size());
        HashMap<SlotIntent, List> partitions = new HashMap<SlotIntent, List>();
        ConnectionIntent connectionIntent = ClusterDistributionChannelWriter.getIntent(commands);
        for (RedisCommand<K, V, ?> redisCommand : commands) {
            ByteBuffer firstEncodedKey;
            if (redisCommand instanceof ClusterCommand) {
                clusterCommands.add((ClusterCommand)redisCommand);
                continue;
            }
            CommandArgs<K, V> args = redisCommand.getArgs();
            ByteBuffer byteBuffer = firstEncodedKey = args != null ? args.getFirstEncodedKey() : null;
            if (firstEncodedKey == null) {
                defaultCommands.add(new ClusterCommand(redisCommand, this, this.executionLimit));
                continue;
            }
            int hash = SlotHash.getSlot(args.getFirstEncodedKey());
            List commandPartition = partitions.computeIfAbsent(SlotIntent.of(connectionIntent, hash), slotIntent -> new ArrayList());
            commandPartition.add(new ClusterCommand(redisCommand, this, this.executionLimit));
        }
        for (Map.Entry entry : partitions.entrySet()) {
            SlotIntent slotIntent2 = (SlotIntent)entry.getKey();
            RedisChannelHandler connection = (RedisChannelHandler)((Object)this.clusterConnectionProvider.getConnection(slotIntent2.connectionIntent, slotIntent2.slotHash));
            RedisChannelWriter channelWriter = connection.getChannelWriter();
            if (channelWriter instanceof ClusterDistributionChannelWriter) {
                ClusterDistributionChannelWriter writer = (ClusterDistributionChannelWriter)channelWriter;
                channelWriter = writer.defaultWriter;
            }
            if (channelWriter == null || channelWriter == this || channelWriter == this.defaultWriter) continue;
            channelWriter.write((Collection)entry.getValue());
        }
        clusterCommands.forEach(this::write);
        defaultCommands.forEach(this.defaultWriter::write);
        return commands;
    }

    static ConnectionIntent getIntent(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        boolean w = false;
        boolean r = false;
        ConnectionIntent singleConnectionIntent = ConnectionIntent.WRITE;
        for (RedisCommand<?, ?, ?> command : commands) {
            if (command instanceof ClusterCommand) continue;
            singleConnectionIntent = ClusterDistributionChannelWriter.getIntent(command.getType());
            if (singleConnectionIntent == ConnectionIntent.READ) {
                r = true;
            }
            if (singleConnectionIntent == ConnectionIntent.WRITE) {
                w = true;
            }
            if (!r || !w) continue;
            return ConnectionIntent.WRITE;
        }
        return singleConnectionIntent;
    }

    private static ConnectionIntent getIntent(ProtocolKeyword type) {
        return ReadOnlyCommands.isReadOnlyCommand(type) ? ConnectionIntent.READ : ConnectionIntent.WRITE;
    }

    static HostAndPort getMoveTarget(String errorMessage) {
        LettuceAssert.notEmpty((CharSequence)errorMessage, "ErrorMessage must not be empty");
        LettuceAssert.isTrue(errorMessage.startsWith(CommandKeyword.MOVED.name()), "ErrorMessage must start with " + CommandKeyword.MOVED);
        String[] movedMessageParts = errorMessage.split(" ");
        LettuceAssert.isTrue(movedMessageParts.length >= 3, "ErrorMessage must consist of 3 tokens (" + errorMessage + ")");
        return HostAndPort.parseCompat(movedMessageParts[2]);
    }

    static HostAndPort getAskTarget(String errorMessage) {
        LettuceAssert.notEmpty((CharSequence)errorMessage, "ErrorMessage must not be empty");
        LettuceAssert.isTrue(errorMessage.startsWith(CommandKeyword.ASK.name()), "ErrorMessage must start with " + CommandKeyword.ASK);
        String[] movedMessageParts = errorMessage.split(" ");
        LettuceAssert.isTrue(movedMessageParts.length >= 3, "ErrorMessage must consist of 3 tokens (" + errorMessage + ")");
        return HostAndPort.parseCompat(movedMessageParts[2]);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closeAsync().join();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        this.closed = true;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if (this.defaultWriter != null) {
            futures.add(this.defaultWriter.closeAsync());
        }
        if (this.clusterConnectionProvider != null) {
            futures.add(this.clusterConnectionProvider.closeAsync());
            this.clusterConnectionProvider = null;
        }
        return Futures.allOf(futures);
    }

    public void disconnectDefaultEndpoint() {
        this.unwrapDefaultEndpoint().disconnect();
    }

    private DefaultEndpoint unwrapDefaultEndpoint() {
        RedisChannelWriter writer = this.defaultWriter;
        while (!(writer instanceof DefaultEndpoint)) {
            if (writer instanceof CommandListenerWriter) {
                writer = ((CommandListenerWriter)writer).getDelegate();
                continue;
            }
            if (writer instanceof CommandExpiryWriter) {
                writer = ((CommandExpiryWriter)writer).getDelegate();
                continue;
            }
            throw new IllegalStateException(String.format("Cannot unwrap defaultWriter %s into DefaultEndpoint", writer));
        }
        return (DefaultEndpoint)writer;
    }

    @Override
    public void setConnectionFacade(ConnectionFacade redisChannelHandler) {
        this.defaultWriter.setConnectionFacade(redisChannelHandler);
    }

    @Override
    public ClientResources getClientResources() {
        return this.defaultWriter.getClientResources();
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.getClusterConnectionProvider().setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.getClusterConnectionProvider().flushCommands();
    }

    public ClusterConnectionProvider getClusterConnectionProvider() {
        return this.clusterConnectionProvider;
    }

    @Override
    public void reset() {
        this.defaultWriter.reset();
        this.clusterConnectionProvider.reset();
    }

    public void setClusterConnectionProvider(ClusterConnectionProvider clusterConnectionProvider) {
        this.clusterConnectionProvider = clusterConnectionProvider;
        this.asyncClusterConnectionProvider = (AsyncClusterConnectionProvider)((Object)clusterConnectionProvider);
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
        if (this.clusterConnectionProvider != null) {
            this.clusterConnectionProvider.setPartitions(partitions);
        }
    }

    public Partitions getPartitions() {
        return this.partitions;
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.clusterConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.clusterConnectionProvider.getReadFrom();
    }

    static class SlotIntent {
        final int slotHash;
        final ConnectionIntent connectionIntent;
        private static final SlotIntent[] READ = new SlotIntent[16384];
        private static final SlotIntent[] WRITE = new SlotIntent[16384];

        private SlotIntent(int slotHash, ConnectionIntent connectionIntent) {
            this.slotHash = slotHash;
            this.connectionIntent = connectionIntent;
        }

        public static SlotIntent of(ConnectionIntent connectionIntent, int slot) {
            if (connectionIntent == ConnectionIntent.READ) {
                return READ[slot];
            }
            return WRITE[slot];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SlotIntent)) {
                return false;
            }
            SlotIntent that = (SlotIntent)o;
            if (this.slotHash != that.slotHash) {
                return false;
            }
            return this.connectionIntent == that.connectionIntent;
        }

        public int hashCode() {
            int result = this.slotHash;
            result = 31 * result + this.connectionIntent.hashCode();
            return result;
        }

        static {
            IntStream.range(0, 16384).forEach(i -> {
                SlotIntent.READ[i] = new SlotIntent(i, ConnectionIntent.READ);
                SlotIntent.WRITE[i] = new SlotIntent(i, ConnectionIntent.WRITE);
            });
        }
    }
}

