/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandArgs;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;

public class XReadArgs {
    private Long block;
    private Long count;
    private boolean noack;

    public XReadArgs block(long milliseconds) {
        this.block = milliseconds;
        return this;
    }

    public XReadArgs block(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Block timeout must not be null");
        return this.block(timeout.toMillis());
    }

    public XReadArgs count(long count) {
        this.count = count;
        return this;
    }

    public XReadArgs noack(boolean noack) {
        this.noack = noack;
        return this;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.block != null) {
            args.add(CommandKeyword.BLOCK).add(this.block);
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
        }
        if (this.noack) {
            args.add(CommandKeyword.NOACK);
        }
    }

    public static class StreamOffset<K> {
        final K name;
        final String offset;

        private StreamOffset(K name, String offset) {
            this.name = name;
            this.offset = offset;
        }

        public static <K> StreamOffset<K> latest(K name) {
            LettuceAssert.notNull(name, "Stream must not be null");
            return new StreamOffset<K>(name, "$");
        }

        public static <K> StreamOffset<K> lastConsumed(K name) {
            LettuceAssert.notNull(name, "Stream must not be null");
            return new StreamOffset<K>(name, ">");
        }

        public static <K> StreamOffset<K> from(K name, String offset) {
            LettuceAssert.notNull(name, "Stream must not be null");
            LettuceAssert.notEmpty((CharSequence)offset, "Offset must not be empty");
            return new StreamOffset<K>(name, offset);
        }

        public K getName() {
            return this.name;
        }

        public String getOffset() {
            return this.offset;
        }

        public String toString() {
            return String.format("%s:%s", this.name, this.offset);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static XReadArgs block(long milliseconds) {
            return new XReadArgs().block(milliseconds);
        }

        public static XReadArgs block(Duration timeout) {
            LettuceAssert.notNull((Object)timeout, "Block timeout must not be null");
            return Builder.block(timeout.toMillis());
        }

        public static XReadArgs count(long count) {
            return new XReadArgs().count(count);
        }

        public static XReadArgs noack() {
            return Builder.noack(true);
        }

        public static XReadArgs noack(boolean noack) {
            return new XReadArgs().noack(noack);
        }
    }
}

