/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.CompositeArgument;
import com.grinderwolf.swm.internal.lettuce.core.Limit;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandArgs;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandKeyword;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandType;
import java.util.ArrayList;
import java.util.List;

public class SortArgs
implements CompositeArgument {
    private String by;
    private Limit limit = Limit.unlimited();
    private List<String> get;
    private CommandKeyword order;
    private boolean alpha;

    public SortArgs by(String pattern) {
        LettuceAssert.notNull((Object)pattern, "Pattern must not be null");
        this.by = pattern;
        return this;
    }

    public SortArgs limit(long offset, long count) {
        return this.limit(Limit.create(offset, count));
    }

    public SortArgs limit(Limit limit) {
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
        this.limit = limit;
        return this;
    }

    public SortArgs get(String pattern) {
        LettuceAssert.notNull((Object)pattern, "Pattern must not be null");
        if (this.get == null) {
            this.get = new ArrayList<String>();
        }
        this.get.add(pattern);
        return this;
    }

    public SortArgs asc() {
        this.order = CommandKeyword.ASC;
        return this;
    }

    public SortArgs desc() {
        this.order = CommandKeyword.DESC;
        return this;
    }

    public SortArgs alpha() {
        this.alpha = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.by != null) {
            args.add(CommandKeyword.BY);
            args.add(this.by);
        }
        if (this.get != null) {
            for (String pattern : this.get) {
                args.add(CommandType.GET);
                args.add(pattern);
            }
        }
        if (this.limit != null && this.limit.isLimited()) {
            args.add(CommandKeyword.LIMIT);
            args.add(this.limit.getOffset());
            args.add(this.limit.getCount());
        }
        if (this.order != null) {
            args.add(this.order);
        }
        if (this.alpha) {
            args.add(CommandKeyword.ALPHA);
        }
    }

    <K, V> void build(CommandArgs<K, V> args, K store) {
        this.build(args);
        if (store != null) {
            args.add(CommandKeyword.STORE);
            args.addKey(store);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static SortArgs by(String pattern) {
            return new SortArgs().by(pattern);
        }

        public static SortArgs limit(long offset, long count) {
            return new SortArgs().limit(offset, count);
        }

        public static SortArgs get(String pattern) {
            return new SortArgs().get(pattern);
        }

        public static SortArgs asc() {
            return new SortArgs().asc();
        }

        public static SortArgs desc() {
            return new SortArgs().desc();
        }

        public static SortArgs alpha() {
            return new SortArgs().alpha();
        }
    }
}

