/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class SocketOptions {
    public static final long DEFAULT_CONNECT_TIMEOUT = 10L;
    public static final TimeUnit DEFAULT_CONNECT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final Duration DEFAULT_CONNECT_TIMEOUT_DURATION = Duration.ofSeconds(10L);
    public static final boolean DEFAULT_SO_KEEPALIVE = false;
    public static final boolean DEFAULT_SO_NO_DELAY = true;
    private final Duration connectTimeout;
    private final KeepAliveOptions keepAlive;
    private final boolean extendedKeepAlive;
    private final boolean tcpNoDelay;

    protected SocketOptions(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.keepAlive = builder.keepAlive;
        this.extendedKeepAlive = builder.extendedKeepAlive;
        this.tcpNoDelay = builder.tcpNoDelay;
    }

    protected SocketOptions(SocketOptions original) {
        this.connectTimeout = original.getConnectTimeout();
        this.keepAlive = original.getKeepAlive();
        this.extendedKeepAlive = original.isExtendedKeepAlive();
        this.tcpNoDelay = original.isTcpNoDelay();
    }

    public static SocketOptions copyOf(SocketOptions options) {
        return new SocketOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SocketOptions create() {
        return SocketOptions.builder().build();
    }

    public Builder mutate() {
        Builder builder = SocketOptions.builder();
        builder.connectTimeout = this.getConnectTimeout();
        builder.keepAlive = this.getKeepAlive();
        builder.tcpNoDelay = this.isTcpNoDelay();
        return builder;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive.isEnabled();
    }

    public KeepAliveOptions getKeepAlive() {
        return this.keepAlive;
    }

    boolean isExtendedKeepAlive() {
        return this.extendedKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public static class KeepAliveOptions {
        public static final int DEFAULT_COUNT = 9;
        public static final Duration DEFAULT_IDLE = Duration.ofHours(2L);
        public static final Duration DEFAULT_INTERVAL = Duration.ofSeconds(75L);
        private final int count;
        private final boolean enabled;
        private final Duration idle;
        private final Duration interval;

        private KeepAliveOptions(Builder builder) {
            this.count = builder.count;
            this.enabled = builder.enabled;
            this.idle = builder.idle;
            this.interval = builder.interval;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder mutate() {
            Builder builder = KeepAliveOptions.builder();
            builder.enabled = this.isEnabled();
            builder.count = this.getCount();
            builder.idle = this.getIdle();
            builder.interval = this.getInterval();
            return builder;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Duration getIdle() {
            return this.idle;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public static class Builder {
            private int count = 9;
            private boolean enabled = false;
            private Duration idle = DEFAULT_IDLE;
            private Duration interval = DEFAULT_INTERVAL;

            private Builder() {
            }

            public Builder count(int count) {
                LettuceAssert.isTrue(count >= 0, "Count must be greater 0");
                this.count = count;
                return this;
            }

            public Builder enable() {
                return this.enable(true);
            }

            public Builder disable() {
                return this.enable(false);
            }

            public Builder enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder idle(Duration idle) {
                LettuceAssert.notNull((Object)idle, "Idle time must not be null");
                LettuceAssert.isTrue(!idle.isNegative(), "Idle time must not be begative");
                this.idle = idle;
                return this;
            }

            public Builder interval(Duration interval) {
                LettuceAssert.notNull((Object)interval, "Idle time must not be null");
                LettuceAssert.isTrue(!interval.isNegative(), "Idle time must not be begative");
                this.interval = interval;
                return this;
            }

            public KeepAliveOptions build() {
                return new KeepAliveOptions(this);
            }
        }
    }

    public static class Builder {
        private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT_DURATION;
        private KeepAliveOptions keepAlive = KeepAliveOptions.builder().enable(false).build();
        private boolean tcpNoDelay = true;
        private boolean extendedKeepAlive = false;

        private Builder() {
        }

        public Builder connectTimeout(Duration connectTimeout) {
            LettuceAssert.notNull((Object)connectTimeout, "Connection timeout must not be null");
            LettuceAssert.isTrue(connectTimeout.toNanos() > 0L, "Connect timeout must be greater 0");
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Deprecated
        public Builder connectTimeout(long connectTimeout, TimeUnit connectTimeoutUnit) {
            LettuceAssert.isTrue(connectTimeout > 0L, "Connect timeout must be greater 0");
            LettuceAssert.notNull((Object)connectTimeoutUnit, "TimeUnit must not be null");
            return this.connectTimeout(Duration.ofNanos(connectTimeoutUnit.toNanos(connectTimeout)));
        }

        public Builder keepAlive(boolean keepAlive) {
            this.keepAlive = KeepAliveOptions.builder().enable(keepAlive).build();
            this.extendedKeepAlive = false;
            return this;
        }

        public Builder keepAlive(KeepAliveOptions keepAlive) {
            LettuceAssert.notNull((Object)keepAlive, "KeepAlive options must not be null");
            this.keepAlive = keepAlive;
            this.extendedKeepAlive = true;
            return this;
        }

        public Builder tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public SocketOptions build() {
            return new SocketOptions(this);
        }
    }
}

