/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.KeyScanCursor;
import com.grinderwolf.swm.internal.lettuce.core.KeyValue;
import com.grinderwolf.swm.internal.lettuce.core.MapScanCursor;
import com.grinderwolf.swm.internal.lettuce.core.ScanArgs;
import com.grinderwolf.swm.internal.lettuce.core.ScanCursor;
import com.grinderwolf.swm.internal.lettuce.core.ScoredValue;
import com.grinderwolf.swm.internal.lettuce.core.ScoredValueScanCursor;
import com.grinderwolf.swm.internal.lettuce.core.ValueScanCursor;
import com.grinderwolf.swm.internal.lettuce.core.api.sync.RedisHashCommands;
import com.grinderwolf.swm.internal.lettuce.core.api.sync.RedisKeyCommands;
import com.grinderwolf.swm.internal.lettuce.core.api.sync.RedisSetCommands;
import com.grinderwolf.swm.internal.lettuce.core.api.sync.RedisSortedSetCommands;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class ScanIterator<T>
implements Iterator<T> {
    private ScanIterator() {
    }

    public static <K, V> ScanIterator<K> scan(RedisKeyCommands<K, V> commands) {
        return ScanIterator.scan(commands, Optional.empty());
    }

    public static <K, V> ScanIterator<K> scan(RedisKeyCommands<K, V> commands, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanIterator.scan(commands, Optional.of(scanArgs));
    }

    private static <K, V> ScanIterator<K> scan(final RedisKeyCommands<K, V> commands, final Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisKeyCommands must not be null");
        return new SyncScanIterator<K>(){

            @Override
            protected ScanCursor nextScanCursor(ScanCursor scanCursor) {
                KeyScanCursor cursor = this.getNextScanCursor(scanCursor);
                this.chunk = cursor.getKeys().iterator();
                return cursor;
            }

            private KeyScanCursor<K> getNextScanCursor(ScanCursor scanCursor) {
                if (scanCursor == null) {
                    return scanArgs.map(commands::scan).orElseGet(commands::scan);
                }
                return scanArgs.map(scanArgs -> commands.scan(scanCursor, (ScanArgs)scanArgs)).orElseGet(() -> commands.scan(scanCursor));
            }
        };
    }

    public static <K, V> ScanIterator<KeyValue<K, V>> hscan(RedisHashCommands<K, V> commands, K key) {
        return ScanIterator.hscan(commands, key, Optional.empty());
    }

    public static <K, V> ScanIterator<KeyValue<K, V>> hscan(RedisHashCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanIterator.hscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> ScanIterator<KeyValue<K, V>> hscan(final RedisHashCommands<K, V> commands, final K key, final Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisKeyCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return new SyncScanIterator<KeyValue<K, V>>(){

            @Override
            protected ScanCursor nextScanCursor(ScanCursor scanCursor) {
                MapScanCursor cursor = this.getNextScanCursor(scanCursor);
                this.chunk = cursor.getMap().keySet().stream().map(k -> KeyValue.fromNullable(k, cursor.getMap().get(k))).iterator();
                return cursor;
            }

            private MapScanCursor<K, V> getNextScanCursor(ScanCursor scanCursor) {
                if (scanCursor == null) {
                    return scanArgs.map(scanArgs -> commands.hscan(key, (ScanArgs)scanArgs)).orElseGet(() -> commands.hscan(key));
                }
                return scanArgs.map(scanArgs -> commands.hscan(key, scanCursor, (ScanArgs)scanArgs)).orElseGet(() -> commands.hscan(key, scanCursor));
            }
        };
    }

    public static <K, V> ScanIterator<V> sscan(RedisSetCommands<K, V> commands, K key) {
        return ScanIterator.sscan(commands, key, Optional.empty());
    }

    public static <K, V> ScanIterator<V> sscan(RedisSetCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanIterator.sscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> ScanIterator<V> sscan(final RedisSetCommands<K, V> commands, final K key, final Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisKeyCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return new SyncScanIterator<V>(){

            @Override
            protected ScanCursor nextScanCursor(ScanCursor scanCursor) {
                ValueScanCursor cursor = this.getNextScanCursor(scanCursor);
                this.chunk = cursor.getValues().iterator();
                return cursor;
            }

            private ValueScanCursor<V> getNextScanCursor(ScanCursor scanCursor) {
                if (scanCursor == null) {
                    return scanArgs.map(scanArgs -> commands.sscan(key, (ScanArgs)scanArgs)).orElseGet(() -> commands.sscan(key));
                }
                return scanArgs.map(scanArgs -> commands.sscan(key, scanCursor, (ScanArgs)scanArgs)).orElseGet(() -> commands.sscan(key, scanCursor));
            }
        };
    }

    public static <K, V> ScanIterator<ScoredValue<V>> zscan(RedisSortedSetCommands<K, V> commands, K key) {
        return ScanIterator.zscan(commands, key, Optional.empty());
    }

    public static <K, V> ScanIterator<ScoredValue<V>> zscan(RedisSortedSetCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull((Object)scanArgs, "ScanArgs must not be null");
        return ScanIterator.zscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> ScanIterator<ScoredValue<V>> zscan(final RedisSortedSetCommands<K, V> commands, final K key, final Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisKeyCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        return new SyncScanIterator<ScoredValue<V>>(){

            @Override
            protected ScanCursor nextScanCursor(ScanCursor scanCursor) {
                ScoredValueScanCursor cursor = this.getNextScanCursor(scanCursor);
                this.chunk = cursor.getValues().iterator();
                return cursor;
            }

            private ScoredValueScanCursor<V> getNextScanCursor(ScanCursor scanCursor) {
                if (scanCursor == null) {
                    return scanArgs.map(scanArgs -> commands.zscan(key, (ScanArgs)scanArgs)).orElseGet(() -> commands.zscan(key));
                }
                return scanArgs.map(scanArgs -> commands.zscan(key, scanCursor, (ScanArgs)scanArgs)).orElseGet(() -> commands.zscan(key, scanCursor));
            }
        };
    }

    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this, 0L, 0), false);
    }

    private static abstract class SyncScanIterator<T>
    extends ScanIterator<T> {
        private ScanCursor scanCursor;
        protected Iterator<T> chunk = null;

        private SyncScanIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.scanCursor == null || !this.scanCursor.isFinished()) {
                if (this.scanCursor == null || !this.hasChunkElements()) {
                    this.scanCursor = this.nextScanCursor(this.scanCursor);
                }
                if (!this.hasChunkElements()) continue;
                return true;
            }
            return this.hasChunkElements();
        }

        private boolean hasChunkElements() {
            return this.chunk.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.chunk.next();
        }

        protected abstract ScanCursor nextScanCursor(ScanCursor var1);
    }
}

