/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.RedisCredentials;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface RedisCredentialsProvider {
    public Mono<RedisCredentials> resolveCredentials();

    public static RedisCredentialsProvider from(Supplier<RedisCredentials> supplier) {
        LettuceAssert.notNull(supplier, "Supplier must not be null");
        return () -> Mono.fromSupplier(supplier);
    }

    @FunctionalInterface
    public static interface ImmediateRedisCredentialsProvider
    extends RedisCredentialsProvider {
        @Override
        default public Mono<RedisCredentials> resolveCredentials() {
            return Mono.just(this.resolveCredentialsNow());
        }

        public RedisCredentials resolveCredentialsNow();
    }
}

