/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.AbstractRedisClient;
import com.grinderwolf.swm.internal.lettuce.core.ClientOptions;
import com.grinderwolf.swm.internal.lettuce.core.CloseEvents;
import com.grinderwolf.swm.internal.lettuce.core.CommandListenerWriter;
import com.grinderwolf.swm.internal.lettuce.core.ConnectionEvents;
import com.grinderwolf.swm.internal.lettuce.core.FutureSyncInvocationHandler;
import com.grinderwolf.swm.internal.lettuce.core.RedisChannelWriter;
import com.grinderwolf.swm.internal.lettuce.core.RedisConnectionStateListener;
import com.grinderwolf.swm.internal.lettuce.core.api.AsyncCloseable;
import com.grinderwolf.swm.internal.lettuce.core.api.StatefulConnection;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandExpiryWriter;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandWrapper;
import com.grinderwolf.swm.internal.lettuce.core.protocol.ConnectionFacade;
import com.grinderwolf.swm.internal.lettuce.core.protocol.RedisCommand;
import com.grinderwolf.swm.internal.lettuce.core.protocol.TracedCommand;
import com.grinderwolf.swm.internal.lettuce.core.resource.ClientResources;
import com.grinderwolf.swm.internal.lettuce.core.tracing.TraceContextProvider;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class RedisChannelHandler<K, V>
implements Closeable,
ConnectionFacade {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisChannelHandler.class);
    private static final AtomicIntegerFieldUpdater<RedisChannelHandler> CLOSED = AtomicIntegerFieldUpdater.newUpdater(RedisChannelHandler.class, "closed");
    private static final int ST_OPEN = 0;
    private static final int ST_CLOSED = 1;
    private Duration timeout;
    private final ConnectionEvents connectionEvents = new ConnectionEvents();
    private CloseEvents closeEvents = new CloseEvents();
    private final RedisChannelWriter channelWriter;
    private final ClientResources clientResources;
    private final boolean tracingEnabled;
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private volatile int closed = 0;
    private volatile boolean active = true;
    private volatile ClientOptions clientOptions;

    public RedisChannelHandler(RedisChannelWriter writer, Duration timeout) {
        this.channelWriter = writer;
        this.clientResources = writer.getClientResources();
        this.tracingEnabled = this.clientResources.tracing().isEnabled();
        writer.setConnectionFacade(this);
        this.setTimeout(timeout);
    }

    public void addListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull((Object)listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.addListener(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull((Object)listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.removeListener(listener);
    }

    public void setTimeout(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout duration must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout duration must be greater or equal to zero");
        this.timeout = timeout;
        RedisChannelWriter writer = this.channelWriter;
        if (writer instanceof CommandListenerWriter) {
            writer = ((CommandListenerWriter)this.channelWriter).getDelegate();
        }
        if (writer instanceof CommandExpiryWriter) {
            ((CommandExpiryWriter)writer).setTimeout(timeout);
        }
    }

    @Override
    public void close() {
        if (this.debugEnabled) {
            logger.debug("close()");
        }
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.debugEnabled) {
            logger.debug("closeAsync()");
        }
        if (CLOSED.get(this) == 1) {
            logger.warn("Connection is already closed");
            return this.closeFuture;
        }
        if (CLOSED.compareAndSet(this, 0, 1)) {
            this.active = false;
            CompletableFuture<Void> future = this.channelWriter.closeAsync();
            future.whenComplete((v, t) -> {
                this.closeEvents.fireEventClosed(this);
                this.closeEvents = new CloseEvents();
                if (t != null) {
                    this.closeFuture.completeExceptionally((Throwable)t);
                } else {
                    this.closeFuture.complete((Void)v);
                }
            });
        } else {
            logger.warn("Connection is already closed (concurrently)");
        }
        return this.closeFuture;
    }

    protected <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> cmd) {
        if (this.debugEnabled) {
            logger.debug("dispatching command {}", (Object)cmd);
        }
        if (this.tracingEnabled) {
            RedisCommand<K, V, T> commandToSend = cmd;
            TraceContextProvider provider = CommandWrapper.unwrap(cmd, TraceContextProvider.class);
            if (provider == null) {
                commandToSend = new TracedCommand<K, V, T>(cmd, this.clientResources.tracing().initialTraceContextProvider().getTraceContext());
            }
            return this.channelWriter.write(commandToSend);
        }
        return this.channelWriter.write(cmd);
    }

    protected Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        if (this.debugEnabled) {
            logger.debug("dispatching commands {}", (Object)commands);
        }
        if (this.tracingEnabled) {
            ArrayList withTracer = new ArrayList(commands.size());
            Iterator<RedisCommand<K, V, ?>> iterator = commands.iterator();
            while (iterator.hasNext()) {
                RedisCommand<K, V, ?> command;
                RedisCommand<K, V, ?> commandToUse = command = iterator.next();
                TraceContextProvider provider = CommandWrapper.unwrap(command, TraceContextProvider.class);
                if (provider == null) {
                    commandToUse = new TracedCommand(command, this.clientResources.tracing().initialTraceContextProvider().getTraceContext());
                }
                withTracer.add(commandToUse);
            }
            return this.channelWriter.write(withTracer);
        }
        return this.channelWriter.write(commands);
    }

    public void registerCloseables(Collection<Closeable> registry, Closeable ... closeables) {
        registry.addAll(Arrays.asList(closeables));
        this.addListener((Object resource) -> {
            for (Closeable closeable : closeables) {
                if (closeable == this) continue;
                try {
                    if (closeable instanceof AsyncCloseable) {
                        ((AsyncCloseable)((Object)closeable)).closeAsync();
                        continue;
                    }
                    closeable.close();
                }
                catch (IOException e) {
                    if (!this.debugEnabled) continue;
                    logger.debug(e.toString(), e);
                }
            }
            registry.removeAll(Arrays.asList(closeables));
        });
    }

    protected void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    public boolean isClosed() {
        return CLOSED.get(this) == 1;
    }

    @Override
    public void activated() {
        this.active = true;
        CLOSED.set(this, 0);
    }

    @Override
    public void deactivated() {
        this.active = false;
    }

    public RedisChannelWriter getChannelWriter() {
        return this.channelWriter;
    }

    public boolean isOpen() {
        return this.active;
    }

    @Override
    @Deprecated
    public void reset() {
        this.channelWriter.reset();
    }

    public ConnectionEvents getConnectionEvents() {
        return this.connectionEvents;
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    public void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    protected <T> T syncHandler(Object asyncApi, Class<?> ... interfaces) {
        FutureSyncInvocationHandler h = new FutureSyncInvocationHandler((StatefulConnection)((Object)this), asyncApi, interfaces);
        return (T)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), interfaces, (InvocationHandler)h);
    }

    public void setAutoFlushCommands(boolean autoFlush) {
        this.getChannelWriter().setAutoFlushCommands(autoFlush);
    }

    public void flushCommands() {
        this.getChannelWriter().flushCommands();
    }
}

