/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.GeoCoordinates;
import com.grinderwolf.swm.internal.lettuce.core.GeoValue;

public class GeoWithin<V> {
    private final V member;
    private final Double distance;
    private final Long geohash;
    private final GeoCoordinates coordinates;

    public GeoWithin(V member, Double distance, Long geohash, GeoCoordinates coordinates) {
        this.member = member;
        this.distance = distance;
        this.geohash = geohash;
        this.coordinates = coordinates;
    }

    public V getMember() {
        return this.member;
    }

    public Double getDistance() {
        return this.distance;
    }

    public Long getGeohash() {
        return this.geohash;
    }

    public GeoCoordinates getCoordinates() {
        return this.coordinates;
    }

    public GeoValue<V> toValue() {
        return GeoValue.just(this.coordinates, this.member);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoWithin)) {
            return false;
        }
        GeoWithin geoWithin = (GeoWithin)o;
        if (this.member != null ? !this.member.equals(geoWithin.member) : geoWithin.member != null) {
            return false;
        }
        if (this.distance != null ? !this.distance.equals(geoWithin.distance) : geoWithin.distance != null) {
            return false;
        }
        if (this.geohash != null ? !this.geohash.equals(geoWithin.geohash) : geoWithin.geohash != null) {
            return false;
        }
        return !(this.coordinates == null ? geoWithin.coordinates != null : !this.coordinates.equals(geoWithin.coordinates));
    }

    public int hashCode() {
        int result = this.member != null ? this.member.hashCode() : 0;
        result = 31 * result + (this.distance != null ? this.distance.hashCode() : 0);
        result = 31 * result + (this.geohash != null ? this.geohash.hashCode() : 0);
        result = 31 * result + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [member=").append(this.member);
        sb.append(", distance=").append(this.distance);
        sb.append(", geohash=").append(this.geohash);
        sb.append(", coordinates=").append(this.coordinates);
        sb.append(']');
        return sb.toString();
    }
}

