/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.CompositeArgument;
import com.grinderwolf.swm.internal.lettuce.core.GeoArgs;
import com.grinderwolf.swm.internal.lettuce.core.internal.LettuceAssert;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandArgs;
import com.grinderwolf.swm.internal.lettuce.core.protocol.CommandKeyword;

public class GeoRadiusStoreArgs<K>
implements CompositeArgument {
    private K storeKey;
    private K storeDistKey;
    private Long count;
    private GeoArgs.Sort sort = GeoArgs.Sort.none;

    public GeoRadiusStoreArgs withStore(K storeKey) {
        LettuceAssert.notNull(storeKey, "StoreKey must not be null");
        this.storeKey = storeKey;
        return this;
    }

    public GeoRadiusStoreArgs withStoreDist(K storeKey) {
        LettuceAssert.notNull(storeKey, "StoreKey must not be null");
        this.storeDistKey = storeKey;
        return this;
    }

    public GeoRadiusStoreArgs withCount(long count) {
        LettuceAssert.isTrue(count > 0L, "Count must be greater 0");
        this.count = count;
        return this;
    }

    public GeoRadiusStoreArgs asc() {
        return this.sort(GeoArgs.Sort.asc);
    }

    public GeoRadiusStoreArgs desc() {
        return this.sort(GeoArgs.Sort.desc);
    }

    public K getStoreKey() {
        return this.storeKey;
    }

    public K getStoreDistKey() {
        return this.storeDistKey;
    }

    public GeoRadiusStoreArgs sort(GeoArgs.Sort sort) {
        LettuceAssert.notNull((Object)sort, "Sort must not be null");
        this.sort = sort;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.sort != null && this.sort != GeoArgs.Sort.none) {
            args.add(this.sort.name());
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
        }
        if (this.storeKey != null) {
            args.add("STORE").addKey(this.storeKey);
        }
        if (this.storeDistKey != null) {
            args.add("STOREDIST").addKey(this.storeDistKey);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K> GeoRadiusStoreArgs store(K key) {
            return new GeoRadiusStoreArgs<K>().withStore(key);
        }

        public static <K> GeoRadiusStoreArgs withStoreDist(K key) {
            return new GeoRadiusStoreArgs<K>().withStoreDist(key);
        }

        public static <K> GeoRadiusStoreArgs count(long count) {
            return new GeoRadiusStoreArgs().withCount(count);
        }
    }
}

