/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.lettuce.core;

import com.grinderwolf.swm.internal.lettuce.core.RedisCredentialsProvider;
import com.grinderwolf.swm.internal.lettuce.core.RedisURI;
import com.grinderwolf.swm.internal.lettuce.core.StaticCredentialsProvider;
import com.grinderwolf.swm.internal.lettuce.core.protocol.ProtocolVersion;
import java.util.List;

public class ConnectionState {
    private volatile HandshakeResponse handshakeResponse;
    private volatile RedisCredentialsProvider credentialsProvider;
    private volatile int db;
    private volatile boolean readOnly;
    private volatile String clientName;

    public void apply(RedisURI redisURI) {
        this.setClientName(redisURI.getClientName());
        this.setCredentialsProvider(redisURI.getCredentialsProvider());
    }

    public ProtocolVersion getNegotiatedProtocolVersion() {
        return this.handshakeResponse != null ? this.handshakeResponse.getNegotiatedProtocolVersion() : null;
    }

    public Long getConnectionId() {
        return this.handshakeResponse != null ? this.handshakeResponse.getConnectionId() : null;
    }

    public String getRedisVersion() {
        return this.handshakeResponse != null ? this.handshakeResponse.getRedisVersion() : null;
    }

    public String getMode() {
        return this.handshakeResponse != null ? this.handshakeResponse.getMode() : null;
    }

    public String getRole() {
        return this.handshakeResponse != null ? this.handshakeResponse.getRole() : null;
    }

    void setHandshakeResponse(HandshakeResponse handshakeResponse) {
        this.handshakeResponse = handshakeResponse;
    }

    protected void setUserNamePassword(List<char[]> args) {
        if (args.isEmpty()) {
            return;
        }
        this.credentialsProvider = args.size() > 1 ? new StaticCredentialsProvider(new String(args.get(0)), args.get(1)) : new StaticCredentialsProvider(null, args.get(0));
    }

    protected void setCredentialsProvider(RedisCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public RedisCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected void setDb(int db) {
        this.db = db;
    }

    int getDb() {
        return this.db;
    }

    protected void setReadOnly(boolean readOnly2) {
        this.readOnly = readOnly2;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setClientName(String clientName) {
        this.clientName = clientName;
    }

    String getClientName() {
        return this.clientName;
    }

    static class HandshakeResponse {
        private final ProtocolVersion negotiatedProtocolVersion;
        private final Long connectionId;
        private final String redisVersion;
        private final String mode;
        private final String role;

        public HandshakeResponse(ProtocolVersion negotiatedProtocolVersion, Long connectionId, String redisVersion, String mode, String role) {
            this.negotiatedProtocolVersion = negotiatedProtocolVersion;
            this.connectionId = connectionId;
            this.redisVersion = redisVersion;
            this.role = role;
            this.mode = mode;
        }

        public ProtocolVersion getNegotiatedProtocolVersion() {
            return this.negotiatedProtocolVersion;
        }

        public Long getConnectionId() {
            return this.connectionId;
        }

        public String getRedisVersion() {
            return this.redisVersion;
        }

        public String getMode() {
            return this.mode;
        }

        public String getRole() {
            return this.role;
        }
    }
}

