/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.bson.codecs.jsr310;

import com.grinderwolf.swm.internal.bson.BsonReader;
import com.grinderwolf.swm.internal.bson.BsonWriter;
import com.grinderwolf.swm.internal.bson.codecs.DecoderContext;
import com.grinderwolf.swm.internal.bson.codecs.EncoderContext;
import com.grinderwolf.swm.internal.bson.codecs.configuration.CodecConfigurationException;
import com.grinderwolf.swm.internal.bson.codecs.jsr310.DateTimeBasedCodec;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;

public class LocalDateCodec
extends DateTimeBasedCodec<LocalDate> {
    @Override
    public LocalDate decode(BsonReader reader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(this.validateAndReadDateTime(reader)).atZone(ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public void encode(BsonWriter writer, LocalDate value, EncoderContext encoderContext) {
        try {
            writer.writeDateTime(value.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        catch (ArithmeticException e) {
            throw new CodecConfigurationException(String.format("Unsupported LocalDate '%s' could not be converted to milliseconds: %s", value, e.getMessage()), e);
        }
    }

    @Override
    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }
}

