/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.bson.codecs;

import com.grinderwolf.swm.internal.bson.BsonInvalidOperationException;
import com.grinderwolf.swm.internal.bson.BsonReader;
import com.grinderwolf.swm.internal.bson.BsonWriter;
import com.grinderwolf.swm.internal.bson.codecs.Codec;
import com.grinderwolf.swm.internal.bson.codecs.DecoderContext;
import com.grinderwolf.swm.internal.bson.codecs.EncoderContext;
import com.grinderwolf.swm.internal.bson.codecs.NumberCodecHelper;

public class FloatCodec
implements Codec<Float> {
    @Override
    public void encode(BsonWriter writer, Float value, EncoderContext encoderContext) {
        writer.writeDouble(value.floatValue());
    }

    @Override
    public Float decode(BsonReader reader, DecoderContext decoderContext) {
        double value = NumberCodecHelper.decodeDouble(reader);
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Float.", value));
        }
        return Float.valueOf((float)value);
    }

    @Override
    public Class<Float> getEncoderClass() {
        return Float.class;
    }
}

