/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.bson.codecs;

import com.grinderwolf.swm.internal.bson.BsonArray;
import com.grinderwolf.swm.internal.bson.BsonBinary;
import com.grinderwolf.swm.internal.bson.BsonBoolean;
import com.grinderwolf.swm.internal.bson.BsonDateTime;
import com.grinderwolf.swm.internal.bson.BsonDbPointer;
import com.grinderwolf.swm.internal.bson.BsonDecimal128;
import com.grinderwolf.swm.internal.bson.BsonDocument;
import com.grinderwolf.swm.internal.bson.BsonDocumentWrapper;
import com.grinderwolf.swm.internal.bson.BsonDouble;
import com.grinderwolf.swm.internal.bson.BsonInt32;
import com.grinderwolf.swm.internal.bson.BsonInt64;
import com.grinderwolf.swm.internal.bson.BsonJavaScript;
import com.grinderwolf.swm.internal.bson.BsonJavaScriptWithScope;
import com.grinderwolf.swm.internal.bson.BsonMaxKey;
import com.grinderwolf.swm.internal.bson.BsonMinKey;
import com.grinderwolf.swm.internal.bson.BsonNull;
import com.grinderwolf.swm.internal.bson.BsonObjectId;
import com.grinderwolf.swm.internal.bson.BsonRegularExpression;
import com.grinderwolf.swm.internal.bson.BsonString;
import com.grinderwolf.swm.internal.bson.BsonSymbol;
import com.grinderwolf.swm.internal.bson.BsonTimestamp;
import com.grinderwolf.swm.internal.bson.BsonType;
import com.grinderwolf.swm.internal.bson.BsonUndefined;
import com.grinderwolf.swm.internal.bson.BsonValue;
import com.grinderwolf.swm.internal.bson.RawBsonDocument;
import com.grinderwolf.swm.internal.bson.codecs.BsonArrayCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonBinaryCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonBooleanCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonDBPointerCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonDateTimeCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonDecimal128Codec;
import com.grinderwolf.swm.internal.bson.codecs.BsonDocumentCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonDocumentWrapperCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonDoubleCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonInt32Codec;
import com.grinderwolf.swm.internal.bson.codecs.BsonInt64Codec;
import com.grinderwolf.swm.internal.bson.codecs.BsonJavaScriptCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonJavaScriptWithScopeCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonMaxKeyCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonMinKeyCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonNullCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonObjectIdCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonRegularExpressionCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonStringCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonSymbolCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonTimestampCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonTypeClassMap;
import com.grinderwolf.swm.internal.bson.codecs.BsonUndefinedCodec;
import com.grinderwolf.swm.internal.bson.codecs.BsonValueCodec;
import com.grinderwolf.swm.internal.bson.codecs.Codec;
import com.grinderwolf.swm.internal.bson.codecs.RawBsonDocumentCodec;
import com.grinderwolf.swm.internal.bson.codecs.configuration.CodecProvider;
import com.grinderwolf.swm.internal.bson.codecs.configuration.CodecRegistry;
import java.util.HashMap;
import java.util.Map;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        if (BsonArray.class.isAssignableFrom(clazz)) {
            return new BsonArrayCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    static {
        HashMap map = new HashMap();
        map.put(BsonType.NULL, BsonNull.class);
        map.put(BsonType.ARRAY, BsonArray.class);
        map.put(BsonType.BINARY, BsonBinary.class);
        map.put(BsonType.BOOLEAN, BsonBoolean.class);
        map.put(BsonType.DATE_TIME, BsonDateTime.class);
        map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map.put(BsonType.DOCUMENT, BsonDocument.class);
        map.put(BsonType.DOUBLE, BsonDouble.class);
        map.put(BsonType.INT32, BsonInt32.class);
        map.put(BsonType.INT64, BsonInt64.class);
        map.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map.put(BsonType.MIN_KEY, BsonMinKey.class);
        map.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map.put(BsonType.STRING, BsonString.class);
        map.put(BsonType.SYMBOL, BsonSymbol.class);
        map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map);
    }
}

