/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.bson;

import com.grinderwolf.swm.internal.bson.BSONCallback;
import com.grinderwolf.swm.internal.bson.BSONCallbackAdapter;
import com.grinderwolf.swm.internal.bson.BSONDecoder;
import com.grinderwolf.swm.internal.bson.BSONObject;
import com.grinderwolf.swm.internal.bson.BasicBSONCallback;
import com.grinderwolf.swm.internal.bson.BsonBinaryReader;
import com.grinderwolf.swm.internal.bson.BsonWriterSettings;
import com.grinderwolf.swm.internal.bson.ByteBufNIO;
import com.grinderwolf.swm.internal.bson.io.Bits;
import com.grinderwolf.swm.internal.bson.io.ByteBufferBsonInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class BasicBSONDecoder
implements BSONDecoder {
    @Override
    public BSONObject readObject(byte[] bytes) {
        BasicBSONCallback bsonCallback = new BasicBSONCallback();
        this.decode(bytes, (BSONCallback)bsonCallback);
        return (BSONObject)bsonCallback.get();
    }

    @Override
    public BSONObject readObject(InputStream in) throws IOException {
        return this.readObject(this.readFully(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decode(byte[] bytes, BSONCallback callback) {
        BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(bytes))));
        try {
            BSONCallbackAdapter writer = new BSONCallbackAdapter(new BsonWriterSettings(), callback);
            writer.pipe(reader);
            int n = reader.getBsonInput().getPosition();
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public int decode(InputStream in, BSONCallback callback) throws IOException {
        return this.decode(this.readFully(in), callback);
    }

    private byte[] readFully(InputStream input) throws IOException {
        byte[] sizeBytes = new byte[4];
        Bits.readFully(input, sizeBytes);
        int size = Bits.readInt(sizeBytes);
        byte[] buffer = new byte[size];
        System.arraycopy(sizeBytes, 0, buffer, 0, 4);
        Bits.readFully(input, buffer, 4, size - 4);
        return buffer;
    }
}

