/*
 * Decompiled with CFR 0.152.
 */
package com.infernalsuite.aswm.importer;

import com.infernalsuite.aswm.api.world.SlimeWorld;
import com.infernalsuite.aswm.serialization.anvil.AnvilWorldReader;
import com.infernalsuite.aswm.serialization.slime.SlimeSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class SWMImporter {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java -jar slimeworldmanager-importer.jar <path-to-world-folder> [--accept] [--print-error]");
            return;
        }
        File worldDir = new File(args[0]);
        File outputFile = SWMImporter.getDestinationFile(worldDir);
        List<String> argList = Arrays.asList(args);
        boolean hasAccepted = argList.contains("--accept");
        boolean printErrors = argList.contains("--print-error");
        if (!hasAccepted) {
            System.out.println("**** WARNING ****");
            System.out.println("The Slime Format is meant to be used on tiny maps, not big survival worlds. It is recommended to trim your world by using the Prune MCEdit tool to ensure you don't save more chunks than you want to.");
            System.out.println();
            System.out.println("NOTE: This utility will automatically ignore every chunk that doesn't contain any blocks.");
            System.out.print("Do you want to continue? [Y/N]: ");
            Scanner scanner = new Scanner(System.in);
            String response = scanner.next();
            if (!response.equalsIgnoreCase("Y")) {
                System.out.println("Your wish is my command.");
                return;
            }
        }
        try {
            outputFile.createNewFile();
            Files.write(outputFile.toPath(), SlimeSerializer.serialize((SlimeWorld)AnvilWorldReader.INSTANCE.readFromData(worldDir)), new OpenOption[0]);
        }
        catch (IndexOutOfBoundsException ex) {
            System.err.println("Oops, it looks like the world provided is too big to be imported. Please trim it by using the MCEdit tool and try again.");
        }
        catch (IOException ex) {
            System.err.println("Failed to save the world file.");
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            if (printErrors) {
                ex.printStackTrace();
            }
            System.err.println(ex.getMessage());
        }
    }

    public static File getDestinationFile(File worldFolder) {
        return new File(worldFolder.getParentFile(), worldFolder.getName() + ".slime");
    }
}

