/*
 * Decompiled with CFR 0.152.
 */
package com.infernalsuite.aswm.api.world.properties;

import com.flowpowered.nbt.CompoundMap;
import com.flowpowered.nbt.CompoundTag;
import com.infernalsuite.aswm.api.world.properties.SlimeProperty;
import java.util.Map;

public class SlimePropertyMap {
    private final CompoundMap properties;

    public SlimePropertyMap(CompoundMap compoundMap) {
        this.properties = compoundMap;
    }

    public SlimePropertyMap() {
        this(new CompoundMap());
    }

    public <T> T getValue(SlimeProperty<T> property) {
        if (this.properties.containsKey((Object)property.getNbtName())) {
            return property.readValue(this.properties.get((Object)property.getNbtName()));
        }
        return property.getDefaultValue();
    }

    public <T> void setValue(SlimeProperty<T> property, T value) {
        if (property.getValidator() != null && !property.getValidator().apply(value).booleanValue()) {
            throw new IllegalArgumentException("'" + value + "' is not a valid property value.");
        }
        property.writeValue(this.properties, value);
    }

    @Deprecated
    public void setInt(SlimeProperty<Integer> property, int value) {
        this.setValue(property, value);
    }

    @Deprecated
    public void setBoolean(SlimeProperty<Boolean> property, boolean value) {
        this.setValue(property, value);
    }

    @Deprecated
    public void setString(SlimeProperty<String> property, String value) {
        this.setValue(property, value);
    }

    public void merge(SlimePropertyMap propertyMap) {
        this.properties.putAll((Map)propertyMap.properties);
    }

    public CompoundTag toCompound() {
        return new CompoundTag("properties", this.properties);
    }

    public static SlimePropertyMap fromCompound(CompoundTag compound) {
        return new SlimePropertyMap(compound.getValue());
    }

    public SlimePropertyMap clone() {
        return new SlimePropertyMap(new CompoundMap(this.properties));
    }

    public String toString() {
        return "SlimePropertyMap" + this.properties;
    }
}

