/*
 * Decompiled with CFR 0.152.
 */
package com.infernalsuite.aswm.api.world.properties;

import com.flowpowered.nbt.CompoundMap;
import com.flowpowered.nbt.Tag;
import java.util.function.Function;

public abstract class SlimeProperty<T> {
    private final String nbtName;
    private final T defaultValue;
    private final Function<T, Boolean> validator;

    protected SlimeProperty(String nbtName, T defaultValue) {
        this(nbtName, defaultValue, null);
    }

    protected SlimeProperty(String nbtName, T defaultValue, Function<T, Boolean> validator) {
        this.nbtName = nbtName;
        if (defaultValue != null && validator != null && !validator.apply(defaultValue).booleanValue()) {
            throw new IllegalArgumentException("Invalid default value for property " + nbtName + "! " + defaultValue);
        }
        this.defaultValue = defaultValue;
        this.validator = validator;
    }

    protected abstract void writeValue(CompoundMap var1, T var2);

    protected abstract T readValue(Tag<?> var1);

    public String getNbtName() {
        return this.nbtName;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Function<T, Boolean> getValidator() {
        return this.validator;
    }

    public String toString() {
        return "SlimeProperty{nbtName='" + this.nbtName + "', defaultValue=" + this.defaultValue + "}";
    }
}

