/*
 * Decompiled with CFR 0.152.
 */
package com.infernalsuite.aswm.api.world;

import com.flowpowered.nbt.CompoundTag;
import com.infernalsuite.aswm.api.exceptions.WorldAlreadyExistsException;
import com.infernalsuite.aswm.api.loaders.SlimeLoader;
import com.infernalsuite.aswm.api.world.SlimeChunk;
import com.infernalsuite.aswm.api.world.properties.SlimePropertyMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public interface SlimeWorld {
    public String getName();

    public SlimeLoader getLoader();

    public SlimeChunk getChunk(int var1, int var2);

    public Collection<SlimeChunk> getChunkStorage();

    @Deprecated(forRemoval=true)
    default public Map<Long, SlimeChunk> getChunks() {
        throw new UnsupportedOperationException();
    }

    public CompoundTag getExtraData();

    public Collection<CompoundTag> getWorldMaps();

    public SlimePropertyMap getPropertyMap();

    public boolean isReadOnly();

    public SlimeWorld clone(String var1);

    public SlimeWorld clone(String var1, SlimeLoader var2) throws WorldAlreadyExistsException, IOException;

    @Deprecated(forRemoval=true)
    default public SlimeWorld clone(String worldName, SlimeLoader loader, boolean lock) throws WorldAlreadyExistsException, IOException {
        return this.clone(worldName, loader);
    }

    @Deprecated(forRemoval=true)
    default public boolean isLocked() {
        return false;
    }

    public int getDataVersion();
}

